package jp.hasc.hasctool.core.runtime.hierarchize;

import jp.hasc.hasctool.core.runtime.source.AbstractSource;

/**
 * sourceStringプロパティで指定された文字列を、delimiterRegexプロパティ（デフォルトは,）で指定された正規表現で分割し、文字列系列として出力します
 * @author iwasaki
 */
public class PropertyStringSplitter extends AbstractSource {
	private String sourceString_;
	private String delimiterRegex_=",";
	@Override
	protected void run() throws InterruptedException {
		String[] strs=sourceString_.split(delimiterRegex_);
		for(String str:strs) {
			outputMessage(str);
		}
	}
	
	public String getSourceString() {
		return sourceString_;
	}
	public void setSourceString(String sourceString) {
		sourceString_ = sourceString;
	}
	public String getDelimiterRegex() {
		return delimiterRegex_;
	}
	public void setDelimiterRegex(String delimiterRegex) {
		delimiterRegex_ = delimiterRegex;
	}
}
