package jp.hasc.hasctool.ui.views.grapheditor;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class BlockDiagramLabelProvider extends LabelProvider {
	
	@Override
	public Image getImage(Object element) {
		return super.getImage(element);
	}

	@Override
	public String getText(Object element) {
		if( element instanceof BeanBlockObject){
			BeanBlockObject b = (BeanBlockObject)element;
			return b.getBeanBlock().getName();
		}else if( element instanceof ConnectionObject){
			ConnectionObject c = (ConnectionObject)element;
			String name = c.getConnection().getName();
			/*
			if (name==null) name="";
			name+=c.getConnection().getOutputPortReference().getPortName() + " to " + c.getConnection().getInputPortReference().getPortName();
			*/
			return name;
		}
		return super.getText(element);
	}

}
