// based on org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor
/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package jp.hasc.hasctool.ui.bdeditor2.misc;

import jp.hasc.hasctool.ui.bdeditor2.misc.EditableComboBoxCellEditor.IHookComboBoxSelected;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/**
 * 値を文字列で持ち、テキストを編集可能な ComboBoxPropertyDescriptor です。
 * @author iwasaki
 */
public class EditableComboBoxPropertyDescriptor extends PropertyDescriptor {

    /**
     * The labels to display in the combo box
     */
    private String[] labels;

    /**
     * Creates an property descriptor with the given id, display name, and list
     * of value labels to display in the combo box cell editor.
     * 
     * @param id the id of the property
     * @param displayName the name to display for the property
     * @param labelsArray the labels to display in the combo box
     */
    public EditableComboBoxPropertyDescriptor(Object id, String displayName,
            String[] labelsArray) {
        super(id, displayName);
        labels = labelsArray;
    }

    /**
     * The <code>ComboBoxPropertyDescriptor</code> implementation of this 
     * <code>IPropertyDescriptor</code> method creates and returns a new
     * <code>ComboBoxCellEditor</code>.
     * <p>
     * The editor is configured with the current validator if there is one.
     * </p>
     */
    public CellEditor createPropertyEditor(Composite parent) {
    	EditableComboBoxCellEditor editor = new EditableComboBoxCellEditor(parent, labels,
                SWT.READ_ONLY);
        if (getValidator() != null) {
			editor.setValidator(getValidator());
		}
        editor.setHookComboBoxSelected(hookComboBoxSelected_);
        return editor;
    }
    
	private IHookComboBoxSelected hookComboBoxSelected_ = null;
	
	public void setHookComboBoxSelected(IHookComboBoxSelected hookComboBoxSelected) {
		hookComboBoxSelected_ = hookComboBoxSelected;
	}
}
