package jp.hasc.hasctool.ui.bdeditor2.model;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class TextDialogPropertDescriptor extends PropertyDescriptor{
	public TextDialogPropertDescriptor(Object id, String displayName) {
		super(id, displayName);
	}
	
	@Override
	public CellEditor createPropertyEditor(Composite parent) {
		CellEditor e = new DialogCellEditor(parent) {
			@Override
			protected Object openDialogBox(Control w) {
				TextDialog dlg=new TextDialog(w.getShell());
				dlg.setText((String)getValue());
				if (dlg.open()==IDialogConstants.OK_ID) {
					setValue(dlg.getText());
				}
				return getValue();
			}
		};
        if (getValidator() != null) {
			e.setValidator(getValidator());
		}
		return e;
	}
	
}