// based on GEF ShapesEditor example
/*******************************************************************************
 * Copyright (c) 2004, 2005 Elias Volanakis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Elias Volanakis - initial API and implementation
 *******************************************************************************/
package jp.hasc.hasctool.ui.bdeditor2.model.commands;

import jp.hasc.hasctool.core.blockdiagram.model.BeanBlock;
import jp.hasc.hasctool.ui.bdeditor2.Messages;
import jp.hasc.hasctool.ui.bdeditor2.model.BlockDiagramElement;
import jp.hasc.hasctool.ui.bdeditor2.model.BlockElement;
import jp.hasc.hasctool.ui.util.UIUtil;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;

/**
 * @author iwasaki
 */
public class BlockCreateCommand extends Command {
	
	private EditPolicy editPolicy_;
	private Class<?> class_=null;
	//
	/** The new shape. */
	private BlockElement newShape;
	/** ShapeDiagram to add to. */
	private final BlockDiagramElement parent;
	/** The bounds of the new Shape. */
	private Rectangle bounds;


	public BlockCreateCommand(EditPolicy policy, BlockElement newShape, BlockDiagramElement parent,
			Rectangle bounds) {
		this.newShape = newShape;
		this.parent = parent;
		this.bounds = bounds;
		setLabel("shape creation");
		//
		editPolicy_=policy;
	}
	
	@Override
	public void execute() {
		// input a block class name
		if (class_==null) {
			EditPartViewer viewer = editPolicy_.getHost().getRoot().getViewer();
			Shell shell = viewer.getControl().getShell();
			InputDialog dlg = new InputDialog(shell,
					Messages.BlockCreateCommand_NewBlock,Messages.BlockCreateCommand_NewBlockMsg,
					"", null); //$NON-NLS-1$
			if (dlg.open() != Dialog.OK) {
				return;
			}
			String clsName = dlg.getValue();			
			Class<?> cls;
			try{
				cls=Class.forName(clsName);
			}catch(ClassNotFoundException ex) {
				UIUtil.showMessageDialog(shell, ex.toString());
				return;
			}
			//
			class_=cls;
		}
		
		//
		redo();
	}
	
	@Override
	public void redo() {
		if (class_==null) return;
		//
		BeanBlock bb = new BeanBlock();
		bb.setRuntimeClassName(class_.getName());
		bb.setName(parent.getUniqueNameForClass(class_));
		newShape.init(parent, bb);
		newShape.setLocation(getCenterPos(bounds),true);
		parent.addBlock(newShape);
	}
	
	/**
	 * Can execute if all the necessary information has been provided.
	 * 
	 * @see org.eclipse.gef.commands.Command#canExecute()
	 */
	public boolean canExecute() {
		return newShape != null && parent != null && bounds != null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	public void undo() {
		if (class_==null) return;
		parent.removeBlock(newShape);
	}

	public static Point getCenterPos(Rectangle r) {
		return new Point(r.x+r.width/2,r.y+r.height/2);
	}	
}
