package jp.hasc.hasctool.ui.bdeditor2.parts;

import java.beans.PropertyChangeEvent;

import jp.hasc.hasctool.core.util.CoreUtil;
import jp.hasc.hasctool.ui.bdeditor2.model.CommentElement;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.graphics.Color;

/**
 * @author iwasaki
 */
public class CommentEditPart extends ShapeEditPart {
	/** logger for this class */
	private final static org.apache.commons.logging.Log LOG = org.apache.commons.logging.LogFactory
			.getLog(CommentEditPart.class);
	
	public CommentElement getCastedModel() {
		return (CommentElement) getModel();
	}
	
	protected static class CommentFigure extends RectangleFigure {
		private TextFlow textFlow_;

		public CommentFigure() {
			setOpaque(true);
			setBackgroundColor(ColorConstants.tooltipBackground);
			setForegroundColor(ColorConstants.tooltipForeground);
	        LineBorder border = new LineBorder();
	        border.setColor(ColorConstants.gray);
			setBorder(new CompoundBorder(border,new MarginBorder(3)));
			//
			setLayoutManager(new StackLayout());
			FlowPage flowPage=new FlowPage();
			textFlow_=new TextFlow();
			textFlow_.setLayoutManager(new ParagraphTextLayout(textFlow_,
					ParagraphTextLayout.WORD_WRAP_SOFT));
			flowPage.add(textFlow_);
			add(flowPage);
		}
		
		public void setCommentElement(CommentElement ce) {
			setBackgroundColor(parseColorString(ce.getBackgroundColor(), ColorConstants.tooltipBackground));
			setForegroundColor(parseColorString(ce.getForegroundColor(), ColorConstants.tooltipForeground));
			textFlow_.setText(ce.getText());
		}

		private Color parseColorString(String s, Color defaultColor) {
			if (s!=null && !s.isEmpty()) {
				try{
					int v = CoreUtil.hexToInt(s);
					return new Color(null,(v>>16)&0xFF,(v>>8)&0xFF,(v>>0)&0xFF);
				}catch(IllegalArgumentException ex) {
					LOG.info("IllegalArgumentException: "+ex.toString());
					return defaultColor;
				}
			}else{
				return defaultColor;
			}
		}
	}
	
	@Override
	protected IFigure createFigure() {
		return new CommentFigure();
	}
	
	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		String prop = evt.getPropertyName();
		if (CommentElement.TEXT_PROP.equals(prop) || 
			CommentElement.FOREGROUND_COLOR_PROP.equals(prop) || 
			CommentElement.BACKGROUND_COLOR_PROP.equals(prop)) 
		{
			refreshVisuals();
		}
		super.propertyChange(evt);
	}
	
	@Override
	protected void refreshVisuals() {
		CommentFigure f=(CommentFigure)getFigure();
		f.setCommentElement(getCastedModel());
		//
		super.refreshVisuals();
	}

}
