/*
	$Id: CommandLine.cs 6 2009-12-26 00:58:57Z catwalk $
*/
using System;
using System.Collections.Generic;

namespace Hiyoko.Utilities{
	/// <summary>
	/// R}hC͂NXB
	/// </summary>
	public class CommandLine{
		private Dictionary<string, string> options;
		private string[] files;
		
		private static string[] commandLine = null;
		
		public CommandLine(){
			this.Initialize(StringComparer.OrdinalIgnoreCase);
			this.Parse(commandLine);
		}
		
		public CommandLine(string[] arguments){
			this.Initialize(StringComparer.OrdinalIgnoreCase);
			this.Parse(arguments);
		}
		
		public CommandLine(StringComparer comparer){
			this.Initialize(comparer);
			this.Parse(commandLine);
		}
		
		public CommandLine(string[] arguments, StringComparer comparer){
			this.Initialize(comparer);
			this.Parse(arguments);
		}
		
		private void Initialize(StringComparer comparer){
			if(commandLine == null){
				string[] cmdLine = Environment.GetCommandLineArgs();
				int length = cmdLine.Length - 1;
				commandLine = new string[length];
				Array.Copy(cmdLine, 1, commandLine, 0, length);
			}
			this.options = new Dictionary<string, string>(comparer);
		}
		
		private void Parse(string[] arguments){
			this.options.Clear();
			List<string> fileList = new List<string>();
			foreach(string arg in arguments){
				if((arg[0] == '/') && (arg.Length > 1)){
					string key;
					string prm = "";
					int n = arg.IndexOf(":");
					if(n != -1){
						key = arg.Substring(1, n - 1);
						prm = arg.Substring(n + 1);
					}else{
						key = arg.Substring(1);
					}
					if(!(this.options.ContainsKey(key))){
						this.options.Add(key, prm);
					}
				}else{
					fileList.Add(arg);
				}
			}
			files = fileList.ToArray();
		}
		
		public Dictionary<string, string> Options{
			get{
				return this.options;
			}
		}
		
		public string[] Files{
			get{
				return this.files;
			}
		}
	}
}