/*
	$Id: Status.cs 23 2010-01-16 18:25:12Z catwalk $
*/
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Xml.Linq;
using System.Net;
using System.Net.NetworkInformation;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;

namespace Hiyoko.Net.Twitter{
	public struct Status{
		public DateTime CreatedAt{get; private set;}
		public decimal Id{get; private set;}
		public string Text{get; private set;}
		public string Source{get; private set;}
		public bool Trancated{get; private set;}
		public decimal InReplyToStatusId{get; private set;}
		public decimal InReplyToUserId{get; private set;}
		public bool Favorited{get; private set;}
		public string InReplyToScreenName{get; private set;}
		public User User{get; private set;}
		
		public static readonly Status Empty = new Status();
		
		public static Status FromXElement(XElement element){
			Status status = new Status();
			
			DateTime dt;
			if(TwitterAPI.TryParseDateTime((string)element.Element("created_at"), out dt)){
				status.CreatedAt = dt;
			}
			status.Id = (decimal)element.Element("id");
			status.Text = (string)element.Element("text");
			status.Source = (string)element.Element("source");
			status.Trancated = (bool)element.Element("truncated");
			decimal dec;
			if(Decimal.TryParse((string)element.Element("in_reply_to_status_id"), out dec)){
				status.InReplyToStatusId = dec;
			}
			if(Decimal.TryParse((string)element.Element("in_reply_to_user_id"), out dec)){
				status.InReplyToUserId = dec;
			}
			status.InReplyToScreenName = (string)element.Element("in_reply_to_screen_name");
			status.Favorited = (bool)element.Element("favorited");
			
			status.User = User.FromXElement(element.Element("user"));
			
			return status;
		}
		
		public override bool Equals(object obj){
			if(obj is Status){
				return this.Id.Equals(((Status)obj).Id);
			}else{
				return false;
			}
		}
		
		public static bool operator ==(Status a, Status b){
			return (a.Id == b.Id);
		}
		
		public static bool operator !=(Status a, Status b){
			return (a.Id != b.Id);
		}
		
		public override int GetHashCode(){
			return this.Id.GetHashCode();
		}
	}
}