﻿/* テスト */
/* 
 * Debug Status: Not checked.
 * - Fixed __T on this page.
 */
/*
 * File: list-effects.h
 * Purpose: List of effect types
 *
 * This work is free software; you can redistribute it and/or modify it
 * under the terms of either:
 *
 * a) the GNU General Public License as published by the Free Software
 *    Foundation, version 2, or
 *
 * b) the "Angband licence":
 *    This software may be copied and distributed for educational, research,
 *    and not for profit purposes provided that this copyright and statement
 *    are included in all such copies.  Other copyrights may also apply.
 */

/*
 * "rating" is the power rating for an item activation, as a damage-per-blow
 * equivalent (x2). These ratings are used in the calculation of the power (and
 * therefore cost) of an item which has the effect as an activation, but NOT
 * for other items (e.g. potions, scrolls). Hence the use of INIHIBIT_POWER.
 */

/*     name            aim?   rating	short description	*/
EFFECT(XXX	, FALSE, 0,	NULL	, __T("XXX"))
EFFECT(POISON	, FALSE, 0,	__T("poisons you for 2d7+10 turns"), __T("POISON"))
EFFECT(BLIND	, FALSE, 0,	__T("blinds you for 4d25+75 turns"), __T("BLIND"))
EFFECT(SCARE	, FALSE, 0,	__T("induces fear in you for 1d10+10 turns"), __T("SCARE"))
EFFECT(CONFUSE	, FALSE, 0,	__T("confuses you for 4d5+10 turns"), __T("CONFUSE"))
EFFECT(HALLUC	, FALSE, 0,	__T("causes you to hallucinate"), __T("HALLUC"))
EFFECT(PARALYZE	, FALSE, 0,	__T("induces paralysis for 1d5+5 turns"), __T("PARALYZE"))
EFFECT(SLOW	, FALSE, 0,	__T("slows you for 1d25+15 turns"), __T("SLOW"))
EFFECT(CURE_POISON	, FALSE, 1,	__T("neutralizes poison"), __T("CURE_POISON"))
EFFECT(CURE_BLINDNESS	, FALSE, 2,	__T("cures blindness"), __T("CURE_BLINDNESS"))
EFFECT(CURE_PARANOIA	, FALSE, 1,	__T("removes your fear"), __T("CURE_PARANOIA"))
EFFECT(CURE_CONFUSION	, FALSE, 2,	__T("cures confusion"), __T("CURE_CONFUSION"))
EFFECT(CURE_MIND	, FALSE, 3,	__T("cures confusion and hallucination, removes fear and grants you temporary resistance to confusion"), __T("CURE_MIND"))
EFFECT(CURE_BODY	, FALSE, 3,	__T("heals cut damage, and cures stunning, poison and blindness"), __T("CURE_BODY"))
EFFECT(CURE_LIGHT	, FALSE, 1,	__T("heals you a small amount (15% of your wounds, minimum 15HP), heals some cut damage, makes you a little less confused, and cures blindness"), __T("CURE_LIGHT"))
EFFECT(CURE_SERIOUS	, FALSE, 2,	__T("heals you a fair amount (1/5 of your wounds, minimum 25HP), heals cut damage, and cures blindness and confusion"), __T("CURE_SERIOUS"))
EFFECT(CURE_CRITICAL	, FALSE, 3,	__T("heals you a large amount (1/4 of your wounds, minimum 30HP), heals cut damage, and cures stunning, poisoning, blindness, and confusion"), __T("CURE_CRITICAL"))
EFFECT(CURE_FULL	, FALSE, 5,	__T("heals you a really large amount (35% of max HP, minimum 300HP), heals cut damage, and cures stunning, poisoning, blindness, and confusion"), __T("CURE_FULL"))
EFFECT(CURE_FULL2	, FALSE, 11,	__T("restores 1200 hit points, heals cut damage, and cures stunning, poisoning, blindness, and confusion"), __T("CURE_FULL2"))
EFFECT(CURE_NONORLYBIG	, FALSE, 12,	__T("restores 5000 hit points, restores experience and stats, heals cut damage, and cures stunning, poison, blindness, and confusion"), __T("CURE_NONORLYBIG"))
EFFECT(CURE_TEMP	, FALSE, 4,	__T("heals cut damage, and cures all stunning, poison, blindness and confusion"), __T("CURE_TEMP"))
EFFECT(HEAL1	, FALSE, 6,	__T("heals 500 hit points"), __T("HEAL1"))
EFFECT(HEAL2	, FALSE, 9,	__T("heals 1000 hit points"), __T("HEAL2"))
EFFECT(HEAL3	, FALSE, 7,	__T("heals 500 hit points, heals cut damage, and cures stunning"), __T("HEAL3"))
EFFECT(GAIN_EXP	, FALSE, INHIBIT_POWER, __T("grants either 100000 experience points or half the current experience point total plus 10, whichever is less"), __T("GAIN_EXP"))
EFFECT(LOSE_EXP	, FALSE, 0,	__T("drains a quarter of your experience"), __T("LOSE_EXP"))
EFFECT(RESTORE_EXP	, FALSE, 1,	__T("restores your experience"), __T("RESTORE_EXP"))
EFFECT(RESTORE_MANA	, FALSE, 6,	__T("restores your mana points to maximum"), __T("RESTORE_MANA"))
EFFECT(GAIN_STR	, FALSE, INHIBIT_POWER,	__T("restores and increases your strength"), __T("GAIN_STR"))
EFFECT(GAIN_INT	, FALSE, INHIBIT_POWER,	__T("restores and increases your intelligence"), __T("GAIN_INT"))
EFFECT(GAIN_WIS	, FALSE, INHIBIT_POWER,	__T("restores and increases your wisdom"), __T("GAIN_WIS"))
EFFECT(GAIN_DEX	, FALSE, INHIBIT_POWER,	__T("restores and increases your dexterity"), __T("GAIN_DEX"))
EFFECT(GAIN_CON	, FALSE, INHIBIT_POWER,	__T("restores and increases your constitution"), __T("GAIN_CON"))
EFFECT(GAIN_CHR	, FALSE, INHIBIT_POWER,	__T("restores and increases your charisma"), __T("GAIN_CHR"))
EFFECT(GAIN_ALL	, FALSE, INHIBIT_POWER,	__T("restores and increases all your stats"), __T("GAIN_ALL"))
EFFECT(BRAWN	, FALSE, 10,	__T("raises your strength at the expense of a random attribute"), __T("BRAWN"))
EFFECT(INTELLECT	, FALSE, 5,	__T("raises your intelligence at the expense of a random attribute"), __T("INTELLECT"))
EFFECT(CONTEMPLATION	, FALSE, 5,	__T("raises your wisdom at the expense of a random attribute"), __T("CONTEMPLATION"))
EFFECT(TOUGHNESS	, FALSE, 12,	__T("raises your constitution at the expense of a random attribute"), __T("TOUGHNESS"))
EFFECT(NIMBLENESS	, FALSE, 9,	__T("raises your dexterity at the expense of a random attribute"), __T("NIMBLENESS"))
EFFECT(PLEASING	, FALSE, 1,	__T("raises your charisma at the expense of a random attribute"), __T("PLEASING"))
EFFECT(LOSE_STR	, FALSE, 0,	__T("reduces your strength with damage 5d5"), __T("LOSE_STR"))
EFFECT(LOSE_INT	, FALSE, 0,	__T("reduces your intelligence with damage 5d5"), __T("LOSE_INT"))
EFFECT(LOSE_WIS	, FALSE, 0,	__T("reduces your wisdom with damage 5d5"), __T("LOSE_WIS"))
EFFECT(LOSE_DEX	, FALSE, 0,	__T("reduces your dexterity with damage 5d5"), __T("LOSE_DEX"))
EFFECT(LOSE_CON	, FALSE, 0,	__T("reduces your constitution with damage 5d5"), __T("LOSE_CON"))
EFFECT(LOSE_CHR	, FALSE, 0,	__T("reduces your intelligence with damage 5d5"), __T("LOSE_CHR"))
EFFECT(LOSE_CON2	, FALSE, 0,	__T("reduces your constitution with damage 10d10"), __T("LOSE_CON2"))
EFFECT(RESTORE_STR	, FALSE, 4,	__T("restores your strength"), __T("RESTORE_STR"))
EFFECT(RESTORE_INT	, FALSE, 2,	__T("restores your intelligence"), __T("RESTORE_INT"))
EFFECT(RESTORE_WIS	, FALSE, 2,	__T("restores your wisdom"), __T("RESTORE_WIS"))
EFFECT(RESTORE_DEX	, FALSE, 3,	__T("restores your dexterity"), __T("RESTORE_DEX"))
EFFECT(RESTORE_CON	, FALSE, 5,	__T("restores your constitution"), __T("RESTORE_CON"))
EFFECT(RESTORE_CHR	, FALSE, 1,	__T("restores your charisma"), __T("RESTORE_CHR"))
EFFECT(RESTORE_ALL	, FALSE, 8,	__T("restores all your stats"), __T("RESTORE_ALL"))
EFFECT(RESTORE_ST_LEV	, FALSE, 9,	__T("restores all your stats and your experience points"), __T("RESTORE_ST_LEV"))
EFFECT(TMD_INFRA	, FALSE, 1,	__T("extends your infravision by 50 feet for 4d25+100 turns"), __T("TMD_INFRA"))
EFFECT(TMD_SINVIS	, FALSE, 2,	__T("cures blindness and allows you to see invisible things for 2d6+12 turns"), __T("TMD_SINVIS"))
EFFECT(TMD_ESP	, FALSE, 4,	__T("cures blindness and gives you telepathy for 6d6+12 turns"), __T("TMD_ESP"))
EFFECT(ENLIGHTENMENT	, FALSE, 9,	__T("completely lights up and magically maps the level"), __T("ENLIGHTENMENT"))
EFFECT(ENLIGHTENMENT2	, FALSE, 13,	__T("increases your intelligence and wisdom, detects and maps everything in the surrounding area, and identifies all items in your pack"), __T("ENLIGHTENMENT2"))
EFFECT(SELF_KNOW	, FALSE, 3,	__T("grants knowledge of all special powers that you currently possess"), __T("SELF_KNOW"))
EFFECT(HERO	, FALSE, 3,	__T("restores 10 hit points, removes fear and grants you resistance to fear and +12 to-hit for 1d25+25 turns"), __T("HERO"))
EFFECT(SHERO	, FALSE, 5,	__T("restores 30 hit points, removes fear and grants you resistance to fear, +24 to-hit, and -10AC for 1d25+25 turns"), __T("SHERO"))
EFFECT(RESIST_ACID	, FALSE, 2,	__T("grants temporary resistance to acid for 1d10+10 turns"), __T("RESIST_ACID"))
EFFECT(RESIST_ELEC	, FALSE, 2,	__T("grants temporary resistance to electricity for 1d10+10 turns"), __T("RESIST_ELEC"))
EFFECT(RESIST_FIRE	, FALSE, 2,	__T("grants temporary resistance to fire for 1d10+10 turns"), __T("RESIST_FIRE"))
EFFECT(RESIST_COLD	, FALSE, 2,	__T("grants temporary resistance to cold for 1d10+10 turns"), __T("RESIST_COLD"))
EFFECT(RESIST_POIS	, FALSE, 2,	__T("grants temporary resistance to poison for 1d10+10 turns"), __T("RESIST_POIS"))
EFFECT(RESIST_ALL	, FALSE, 7,	__T("grants temporary resistance to acid, electricity, fire, cold and poison for 1d20+20 turns"), __T("RESIST_ALL"))
EFFECT(DETECT_TREASURE	, FALSE, 2,	__T("detects gold and objects nearby"), __T("DETECT_TREASURE"))
EFFECT(DETECT_TRAP	, FALSE, 1,	__T("detects traps nearby"), __T("DETECT_TRAP"))
EFFECT(DETECT_DOORSTAIR	, FALSE, 2,	__T("detects doors and stairs nearby"), __T("DETECT_DOORSTAIR"))
EFFECT(DETECT_INVIS	, FALSE, 1,	__T("detects invisible creatures nearby"), __T("DETECT_INVIS"))
EFFECT(DETECT_EVIL	, FALSE, 1,	__T("detects evil creatures nearby"), __T("DETECT_EVIL"))
EFFECT(DETECT_ALL	, FALSE, 7,	__T("detects treasure, traps, doors, stairs, and all creatures nearby"), __T("DETECT_ALL"))
EFFECT(ENCHANT_TOHIT	, FALSE, 5,	__T("attempts to magically enhance a weapon's to-hit bonus"), __T("ENCHANT_TOHIT"))
EFFECT(ENCHANT_TODAM	, FALSE, 10,	__T("attempts to magically enhance a weapon's to-dam bonus"), __T("ENCHANT_TODAM"))
EFFECT(ENCHANT_WEAPON	, FALSE, 12,	__T("attempts to magically enhance a weapon both to-hit and to-dam"), __T("ENCHANT_WEAPON"))
EFFECT(ENCHANT_ARMOR	, FALSE, 5,	__T("attempts to magically enhance a piece of armour"), __T("ENCHANT_ARMOR"))
EFFECT(ENCHANT_ARMOR2	, FALSE, 8,	__T("attempts to magically enhance a piece of armour with high chance of success"), __T("ENCHANT_ARMOR2"))
EFFECT(IDENTIFY	, FALSE, 9,	__T("reveals to you the extent of an item's magical powers"), __T("IDENTIFY"))
EFFECT(REMOVE_CURSE	, FALSE, 3,	__T("removes all ordinary curses from all equipped items"), __T("REMOVE_CURSE"))
EFFECT(REMOVE_CURSE2	, FALSE, 6,	__T("removes all curses from all equipped items"), __T("REMOVE_CURSE2"))
EFFECT(LIGHT	, FALSE, 2,	__T("lights up an area and inflicts 2d8 damage on light-sensitive creatures"), __T("LIGHT"))
EFFECT(SUMMON_MON	, FALSE, 0,	__T("summons monsters at the current dungeon level"), __T("SUMMON_MON"))
EFFECT(SUMMON_UNDEAD	, FALSE, 0,	__T("summons undead monsters at the current dungeon level"), __T("SUMMON_UNDEAD"))
EFFECT(TELE_PHASE	, FALSE, 2,	__T("teleports you randomly up to 10 squares away"), __T("TELE_PHASE"))
EFFECT(TELE_LONG	, FALSE, 4,	__T("teleports you randomly up to 100 squares away"), __T("TELE_LONG"))
EFFECT(TELE_LEVEL	, FALSE, 7,	__T("teleports you one level up or down"), __T("TELE_LEVEL"))
EFFECT(CONFUSING	, FALSE, 1,	__T("causes your next attack upon a monster to confuse it"), __T("CONFUSING"))
EFFECT(MAPPING	, FALSE, 5,	__T("maps the area around you"), __T("MAPPING"))
EFFECT(RUNE	, FALSE, 10,	__T("inscribes a glyph of warding beneath you, which monsters cannot move onto"), __T("RUNE"))
EFFECT(ACQUIRE	, FALSE, INHIBIT_POWER, __T("creates a good object nearby"), __T("ACQUIRE"))
EFFECT(ACQUIRE2	, FALSE, INHIBIT_POWER, __T("creates a few good items nearby"), __T("ACQUIRE2"))
EFFECT(ANNOY_MON	, FALSE, 0,	__T("awakens all nearby sleeping monsters and hastens all monsters within line of sight"), __T("ANNOY_MON"))
EFFECT(CREATE_TRAP	, FALSE, 0,	__T("creates traps surrounding you"), __T("CREATE_TRAP"))
EFFECT(DESTROY_TDOORS	, FALSE, 1,	__T("destroys all traps and doors surrounding you"), __T("DESTROY_TDOORS"))
EFFECT(RECHARGE	, FALSE, 5,	__T("tries to recharge a wand or staff, destroying the wand or staff on failure"), __T("RECHARGE"))
EFFECT(BANISHMENT	, FALSE, 10,	__T("removes all non-unique monsters represented by a chosen symbol from the level, dealing you damage in the process"), __T("BANISHMENT"))
EFFECT(DARKNESS	, FALSE, 0,	__T("darkens the nearby area and blinds you for 1d5+3 turns"), __T("DARKNESS"))
EFFECT(PROTEVIL	, FALSE, 2,	__T("grants you protection from evil for 1d25 plus 3 times your character level turns"), __T("PROTEVIL"))
EFFECT(SATISFY	, FALSE, 2,	__T("magically renders you well-fed, curing any gastrointestinal problems"), __T("SATISFY"))
EFFECT(CURSE_WEAPON	, FALSE, 0,	__T("curses your currently wielded melee weapon"), __T("CURSE_WEAPON"))
EFFECT(CURSE_ARMOR	, FALSE, 0,	__T("curses your currently worn body armor"), __T("CURSE_ARMOR"))
EFFECT(BLESSING	, FALSE, 1,	__T("increases your AC and to-hit bonus for 1d12+6 turns"), __T("BLESSING"))
EFFECT(BLESSING2	, FALSE, 2,	__T("increases your AC and to-hit bonus for 1d24+12 turns"), __T("BLESSING2"))
EFFECT(BLESSING3	, FALSE, 3,	__T("increases your AC and to-hit bonus for 1d48+24 turns"), __T("BLESSING3"))
EFFECT(RECALL	, FALSE, 5,	__T("returns you from the dungeon or takes you to the dungeon after a short delay"), __T("RECALL"))
EFFECT(DEEP_DESCENT	, FALSE, 6,	__T("transports you two or three levels below your maximum dungeon depth"), __T("DEEP_DESCENT"))
EFFECT(EARTHQUAKES	, FALSE, 1,	__T("causes an earthquake around you"), __T("EARTHQUAKES"))
EFFECT(DESTRUCTION2	, FALSE, 12,	__T("destroys an area around you in the shape of a circle radius 15, and blinds you for 1d10+10 turns"), __T("DESTRUCTION2"))
EFFECT(LOSHASTE	, FALSE, 0,	__T("hastes all monsters within line of sight"), __T("LOSHASTE"))
EFFECT(LOSSLOW	, FALSE, 1,	__T("slows all non-unique monsters within line of sight"), __T("LOSSLOW"))
EFFECT(LOSSLEEP	, FALSE, 2,	__T("sleeps all non-unique creatures within line of sight"), __T("LOSSLEEP"))
EFFECT(LOSCONF	, FALSE, 2,	__T("confuses all non-unique creatures within line of sight"), __T("LOSCONF"))
EFFECT(LOSKILL	, FALSE, 12,	__T("removes all non-unique monsters within 20 squares, dealing you damage in the process"), __T("LOSKILL"))
EFFECT(ILLUMINATION	, FALSE, 2,	__T("lights up the surrounding area, hurting light-sensitive creatures"), __T("ILLUMINATION"))
EFFECT(CLAIRVOYANCE	, FALSE, 11,	__T("maps the entire level and detects objects, traps, doors, and stairs"), __T("CLAIRVOYANCE"))
EFFECT(PROBING	, FALSE, 1,	__T("gives you information on the health and abilities of monsters you can see"), __T("PROBING"))
EFFECT(HASTE	, FALSE, 6,	__T("hastens you for 2d10+20 turns"), __T("HASTE"))
EFFECT(HASTE1	, FALSE, 6,	__T("hastens you for d20+20 turns"), __T("HASTE1"))
EFFECT(HASTE2	, FALSE, 7,	__T("hastens you for d75+75 turns"), __T("HASTE2"))
EFFECT(DISPEL_EVIL	, FALSE, 4,	__T("deals five times your level's damage to all evil creatures that you can see"), __T("DISPEL_EVIL"))
EFFECT(DISPEL_EVIL60	, FALSE, 2,	__T("deals 60 damage to all evil creatures that you can see"), __T("DISPEL_EVIL60"))
EFFECT(DISPEL_UNDEAD	, FALSE, 2,	__T("deals 60 damage to all undead creatures that you can see"), __T("DISPEL_UNDEAD"))
EFFECT(DISPEL_ALL	, FALSE, 4,	__T("deals 120 damage to all creatures that you can see"), __T("DISPEL_ALL"))
EFFECT(SLEEPII	, FALSE, 2,	__T("puts to sleep the monsters around you"), __T("SLEEPII"))
EFFECT(STAR_BALL	, FALSE, 3,	__T("fires a ball of electricity in all directions, each one causing 150 damage"), __T("STAR_BALL"))
EFFECT(RAGE_BLESS_RESIST	, FALSE, 9,	__T("bestows upon you berserk rage, bless, and resistance"), __T("RAGE_BLESS_RESIST"))
EFFECT(RESTORE_LIFE	, FALSE, 1,	__T("restores your experience to full"), __T("RESTORE_LIFE"))
EFFECT(REM_FEAR_POIS	, FALSE, 2,	__T("cures you of fear and poison"), __T("REM_FEAR_POIS"))
EFFECT(FIREBRAND	, FALSE, 12,	__T("brands bolts with fire, in an unbalanced fashion"), __T("FIREBRAND"))
EFFECT(FIRE_BOLT	, TRUE, 1,	__T("creates a fire bolt with damage 9d8"), __T("FIRE_BOLT"))
EFFECT(FIRE_BOLT2	, TRUE, 1,	__T("creates a fire bolt with damage 12d8"), __T("FIRE_BOLT2"))
EFFECT(FIRE_BOLT3	, TRUE, 2,	__T("creates a fire bolt with damage 16d8"), __T("FIRE_BOLT3"))
EFFECT(FIRE_BOLT72	, TRUE, 2,	__T("creates a fire bolt with damage 72"), __T("FIRE_BOLT72"))
EFFECT(FIRE_BALL	, TRUE, 3,	__T("creates a fire ball with damage 144"), __T("FIRE_BALL"))
EFFECT(FIRE_BALL2	, TRUE, 3,	__T("creates a large fire ball with damage 120"), __T("FIRE_BALL2"))
EFFECT(FIRE_BALL200	, TRUE, 4,	__T("creates a large fire ball with damage 200"), __T("FIRE_BALL200"))
EFFECT(COLD_BOLT	, TRUE, 1,	__T("creates a frost bolt with damage 6d8"), __T("COLD_BOLT"))
EFFECT(COLD_BOLT2	, TRUE, 1,	__T("creates a frost bolt with damage 12d8"), __T("COLD_BOLT2"))
EFFECT(COLD_BALL2	, TRUE, 4,	__T("creates a large frost ball with damage 200"), __T("COLD_BALL2"))
EFFECT(COLD_BALL50	, TRUE, 1,	__T("creates a frost ball with damage 50"), __T("COLD_BALL50"))
EFFECT(COLD_BALL100	, TRUE, 2,	__T("creates a frost ball with damage 100"), __T("COLD_BALL100"))
EFFECT(COLD_BALL160	, TRUE, 3,	__T("creates a frost ball with damage 160"), __T("COLD_BALL160"))
EFFECT(ACID_BOLT	, TRUE, 1,	__T("creates an acid bolt with damage 5d8"), __T("ACID_BOLT"))
EFFECT(ACID_BOLT2	, TRUE, 1,	__T("creates an acid bolt with damage 10d8"), __T("ACID_BOLT2"))
EFFECT(ACID_BOLT3	, TRUE, 1,	__T("creates an acid bolt with damage 12d8"), __T("ACID_BOLT3"))
EFFECT(ACID_BALL	, TRUE, 3,	__T("creates an acid ball with damage 125"), __T("ACID_BALL"))
EFFECT(ELEC_BOLT	, TRUE, 1,	__T("creates a lightning bolt with damage 6d6"), __T("ELEC_BOLT"))
EFFECT(ELEC_BALL	, TRUE, 1,	__T("creates a lightning ball with damage 64"), __T("ELEC_BALL"))
EFFECT(ELEC_BALL2	, TRUE, 4,	__T("creates a large lightning ball with damage 250"), __T("ELEC_BALL2"))
EFFECT(DRAIN_LIFE1	, TRUE, 1,	__T("drains up to 90 hit points of life from a target creature"), __T("DRAIN_LIFE1"))
EFFECT(DRAIN_LIFE2	, TRUE, 1,	__T("drains up to 120 hit points of life from a target creature"), __T("DRAIN_LIFE2"))
EFFECT(DRAIN_LIFE3	, TRUE, 2,	__T("drains up to 150 hit points of life from a target creature"), __T("DRAIN_LIFE3"))
EFFECT(DRAIN_LIFE4	, TRUE, 3,	__T("drains up to 250 hit points of life from a target creature"), __T("DRAIN_LIFE4"))
EFFECT(MISSILE	, TRUE, 1,	__T("fires a magic missile with damage 3d4"), __T("MISSILE"))
EFFECT(MANA_BOLT	, TRUE, 1,	__T("fires a mana bolt with damage 12d8"), __T("MANA_BOLT"))
EFFECT(BIZARRE	, TRUE, 20,	__T("does bizarre things"), __T("BIZARRE"))
EFFECT(ARROW	, TRUE, 2,	__T("fires a magical arrow with damage 150"), __T("ARROW"))
EFFECT(STINKING_CLOUD	, TRUE, 1,	__T("fires a stinking cloud with damage 12"), __T("STINKING_CLOUD"))
EFFECT(STONE_TO_MUD	, TRUE, 2,	__T("turns rock into mud"), __T("STONE_TO_MUD"))
EFFECT(TELE_OTHER	, TRUE, 11,	__T("teleports a target monster away"), __T("TELE_OTHER"))
EFFECT(CONFUSE2	, TRUE, 1,	__T("confuses a target monster"), __T("CONFUSE2"))
EFFECT(MON_HEAL	, TRUE, 0,	__T("heals a single monster 4d6 hit points"), __T("MON_HEAL"))
EFFECT(MON_HASTE	, TRUE, 0,	__T("hastes a single monster"), __T("MON_HASTE"))
EFFECT(MON_SLOW	, TRUE, 1,	__T("attempts to magically slow a single monster"), __T("MON_SLOW"))
EFFECT(MON_CONFUSE	, TRUE, 1,	__T("attempts to magically confuse a single monster"), __T("MON_CONFUSE"))
EFFECT(MON_SLEEP	, TRUE, 1,	__T("attempts to induce magical sleep in a single monster"), __T("MON_SLEEP"))
EFFECT(MON_CLONE	, TRUE, 0,	__T("hastes, heals, and magically duplicates a single monster"), __T("MON_CLONE"))
EFFECT(MON_SCARE	, TRUE, 1,	__T("attempts to induce magical fear in a single monster"), __T("MON_SCARE"))
EFFECT(LIGHT_LINE	, TRUE, 1,	__T("lights up part of the dungeon in a straight line"), __T("LIGHT_LINE"))
EFFECT(DISARMING	, TRUE, 1,	__T("destroys traps, unlocks doors and reveals all secret doors in a given direction"), __T("DISARMING"))
EFFECT(TDOOR_DEST	, TRUE, 1,	__T("destroys traps and doors"), __T("TDOOR_DEST"))
EFFECT(POLYMORPH	, TRUE, 1,	__T("polymorphs a monster into another kind of creature"), __T("POLYMORPH"))
EFFECT(STARLIGHT	, FALSE, 1,	__T("fires a line of light in all directions, each one causing light-sensitive creatures 6d8 damage"), __T("STARLIGHT"))
EFFECT(STARLIGHT2	, FALSE, 2,	__T("fires a line of light in all directions, each one causing 10d8 damage"), __T("STARLIGHT2"))
EFFECT(BERSERKER	, FALSE, 5,	__T("puts you in a berserker rage for d50+50 turns"), __T("BERSERKER"))
EFFECT(WONDER	, TRUE, 3,	__T("creates random and unpredictable effects"), __T("WONDER"))
EFFECT(WAND_BREATH	, TRUE, 3,	__T("shoots a large ball of one of the base elements for 120-200 damage"), __T("WAND_BREATH"))
EFFECT(STAFF_MAGI	, FALSE, 7,	__T("restores both intelligence and manapoints to maximum"), __T("STAFF_MAGI"))
EFFECT(STAFF_HOLY	, FALSE, 4,	__T("inflicts damage on evil creatures you can see, cures 50 hit points, heals all temporary effects and grants you protection from evil"), __T("STAFF_HOLY"))
EFFECT(DRINK_GOOD	, FALSE, 0,	NULL, __T("DRINK_GOOD"))
EFFECT(DRINK_BREATH	, TRUE, 1,	__T("causes you to breathe either cold or flames for 80 damage"), __T("DRINK_BREATH"))
EFFECT(DRINK_SALT	, FALSE, 0,	__T("induces vomiting and paralysis for 4 turns, resulting in severe hunger but also curing poison"), __T("DRINK_SALT"))
EFFECT(DRINK_DEATH	, FALSE, 0,	__T("inflicts 5000 points of damage"), __T("DRINK_DEATH"))
EFFECT(DRINK_RUIN	, FALSE, 0,	__T("inflicts 10d10 points of damage and decreases all your stats"), __T("DRINK_RUIN"))
EFFECT(DRINK_DETONATE	, FALSE, 0,	__T("inflicts 50d20 points of damage, severe cuts, and stunning"), __T("DRINK_DETONATE"))
EFFECT(FOOD_GOOD	, FALSE, 0,	NULL, __T("FOOD_GOOD"))
EFFECT(FOOD_WAYBREAD	, FALSE, 1,	__T("restores 4d8 hit points and neutralizes poison"), __T("FOOD_WAYBREAD"))
EFFECT(SHROOM_EMERGENCY	, FALSE, 2,	__T("grants temporary resistance to fire and cold, cures 200HP, but also makes you hallucinate wildly"), __T("SHROOM_EMERGENCY"))
EFFECT(SHROOM_TERROR	, FALSE, 1,	__T("speeds up you temporarily but also makes you mortally afraid"), __T("SHROOM_TERROR"))
EFFECT(SHROOM_STONE	, FALSE, 1,	__T("turns your skin to stone briefly, which grants an extra 40AC but slows you down"), __T("SHROOM_STONE"))
EFFECT(SHROOM_DEBILITY	, FALSE, 1,	__T("restores some mana but also drains either your strength or constitution"), __T("SHROOM_DEBILITY"))
EFFECT(SHROOM_SPRINTING	, FALSE, 1,	__T("hastes you for a while, but then makes you slower for a while afterward"), __T("SHROOM_SPRINTING"))
EFFECT(SHROOM_PURGING	, FALSE, 1,	__T("makes you very hungry but restores constitution and strength"), __T("SHROOM_PURGING"))
EFFECT(RING_ACID	, TRUE, 3,	__T("grants acid resistance for d20+20 turns and creates an acid ball of damage 70"), __T("RING_ACID"))
EFFECT(RING_FLAMES	, TRUE, 3,	__T("grants fire resistance for d20+20 turns and creates a fire ball of damage 80"), __T("RING_FLAMES"))
EFFECT(RING_ICE	, TRUE, 3,	__T("grants cold resistance for d20+20 turns and creates a cold ball of damage 75"), __T("RING_ICE"))
EFFECT(RING_LIGHTNING	, TRUE, 3,	__T("grants electricity resistance for d20+20 turns and creates a lightning ball of damage 85"), __T("RING_LIGHTNING"))
EFFECT(DRAGON_BLUE	, TRUE, 1,	__T("allows you to breathe lightning for 100 damage"), __T("DRAGON_BLUE"))
EFFECT(DRAGON_GREEN	, TRUE, 2,	__T("allows you to breathe poison gas for 150 damage"), __T("DRAGON_GREEN"))
EFFECT(DRAGON_RED	, TRUE, 3,	__T("allows you to breathe fire for 200 damage"), __T("DRAGON_RED"))
EFFECT(DRAGON_MULTIHUED	, TRUE, 4,	__T("allows you to breathe the elements for 250 damage"), __T("DRAGON_MULTIHUED"))
EFFECT(DRAGON_BRONZE	, TRUE, 2,	__T("allows you to breathe confusion for 120 damage"), __T("DRAGON_BRONZE"))
EFFECT(DRAGON_GOLD	, TRUE, 2,	__T("allows you to breathe sound for 130 damage"), __T("DRAGON_GOLD"))
EFFECT(DRAGON_CHAOS	, TRUE, 3,	__T("allows you to breathe chaos or disenchantment for 220 damage"), __T("DRAGON_CHAOS"))
EFFECT(DRAGON_LAW	, TRUE, 3,	__T("allows you to breathe sound/shards for 230 damage"), __T("DRAGON_LAW"))
EFFECT(DRAGON_BALANCE	, TRUE, 4,	__T("allows you to breathe balance for 250 damage"), __T("DRAGON_BALANCE"))
EFFECT(DRAGON_SHINING	, TRUE, 2,	__T("allows you to breathe light or darkness for 200 damage"), __T("DRAGON_SHINING"))
EFFECT(DRAGON_POWER	, TRUE, 5,	__T("allows you to breathe for 300 damage"), __T("DRAGON_POWER"))
EFFECT(TRAP_DOOR	, FALSE, 0,	__T("a trap door which drops you down a level"), __T("TRAP_DOOR"))
EFFECT(TRAP_PIT	, FALSE, 0,	__T("a pit trap - the fall might hurt"), __T("TRAP_PIT"))
EFFECT(TRAP_PIT_SPIKES	, FALSE, 0,	__T("a pit trap, with nasty spikes"), __T("TRAP_PIT_SPIKES"))
EFFECT(TRAP_PIT_POISON	, FALSE, 0,	__T("a pit trap, with poisoned spikes"), __T("TRAP_PIT_POISON"))
EFFECT(TRAP_RUNE_SUMMON	, FALSE, 0,	__T("a rune which summons monsters"), __T("TRAP_RUNE_SUMMON"))
EFFECT(TRAP_RUNE_TELEPORT	, FALSE, 0,	__T("a rune which teleports"), __T("TRAP_RUNE_TELEPORT"))
EFFECT(TRAP_SPOT_FIRE	, FALSE, 0,	__T("a magical fire trap"), __T("TRAP_SPOT_FIRE"))
EFFECT(TRAP_SPOT_ACID	, FALSE, 0,	__T("a magical acid trap"), __T("TRAP_SPOT_ACID"))
EFFECT(TRAP_DART_SLOW	, FALSE, 0,	__T("a dart which slows movements"), __T("TRAP_DART_SLOW"))
EFFECT(TRAP_DART_LOSE_STR	, FALSE, 0,	__T("a dart which drains strength"), __T("TRAP_DART_LOSE_STR"))
EFFECT(TRAP_DART_LOSE_DEX	, FALSE, 0,	__T("a dart which drains dexterity"), __T("TRAP_DART_LOSE_DEX"))
EFFECT(TRAP_DART_LOSE_CON	, FALSE, 0,	__T("a dart which drains constitution"), __T("TRAP_DART_LOSE_CON"))
EFFECT(TRAP_GAS_BLIND	, FALSE, 0,	__T("blinding gas"), __T("TRAP_GAS_BLIND"))
EFFECT(TRAP_GAS_CONFUSE	, FALSE, 0,	__T("confusing gas"), __T("TRAP_GAS_CONFUSE"))
EFFECT(TRAP_GAS_POISON	, FALSE, 0,	__T("poison gas"), __T("TRAP_GAS_POISON"))
EFFECT(TRAP_GAS_SLEEP	, FALSE, 0,	__T("soporific gas"), __T("TRAP_GAS_SLEEP"))
