﻿/* テスト */
/*
 * Debug Status: Not checked.
 * - Fixed __T on this page.
 */
/*
 * File: randname.c
 * Purpose: Random name generation
 *
 * Copyright (c) 2007 Antony Sidwell, Sheldon Simms
 *
 * This work is free software; you can redistribute it and/or modify it
 * under the terms of either:
 *
 * a) the GNU General Public License as published by the Free Software
 *    Foundation, version 2, or
 *
 * b) the "Angband licence":
 *    This software may be copied and distributed for educational, research,
 *    and not for profit purposes provided that this copyright and statement
 *    are included in all such copies.  Other copyrights may also apply.
 */
extern "C"
{
#include "angband.h"
#include "randname.h"
}
/* 
 * Arrays of purely alphabetical, lower-case strings to teach 
 * the name generator with. 
 */
static const _TCHAR *tolkien_names[] =
{
	__T("adanedhel"), __T("adurant"), __T("aeglos"), __T("aegnor"), __T("aelin"), __T("aeluin"),
	__T("aerandir"), __T("aerin"), __T("agarwaen"), __T("aglareb"), __T("aglarond"), __T("aglon"),
	__T("ainulindale"), __T("ainur"), __T("alcarinque"), __T("aldaron"), __T("aldudenie"),
	__T("almaren"), __T("alqualonde"), __T("aman"), __T("amandil"), __T("amarie"), __T("amarth"),
	__T("amlach"), __T("amon"), __T("amras"), __T("amrod"), __T("anach"), __T("anar"), 
	__T("anarion"), __T("ancalagon"), __T("ancalimon"), __T("anarrima"), __T("andor"), 
	__T("andram"), __T("androth"), __T("anduin"), __T("andunie"), __T("anfauglir"), 
	__T("anfauglith"), __T("angainor"), __T("angband"), __T("anghabar"), __T("anglachel"), 
	__T("angrenost"), __T("angrim"), __T("angrist"), __T("angrod"), __T("anguirel"), __T("annael"),
	__T("annatar"), __T("annon"), __T("annuminas"), __T("apanonar"), __T("aradan"), __T("aragorn"),
	__T("araman"), __T("aranel"), __T("aranruth"), __T("aranwe"), __T("aras"), __T("aratan"), 
	__T("aratar"), __T("arathorn"), __T("arda"), __T("ardgalen"), __T("aredhel"), __T("arfeiniel"),
	__T("argonath"), __T("arien"), __T("armenelos"), __T("arminas"), __T("arnor"), __T("aros"), 
	__T("arossiach"), __T("arthad"), __T("arvernien"), __T("arwen"), __T("ascar"), __T("astaldo"), 
	__T("atalante"), __T("atanamir"), __T("atanatari"), __T("atani"), __T("aule"), __T("avallone"),
	__T("avari"), __T("avathar"), __T("balan"), __T("balar"), __T("balrog"), __T("barad"), 
	__T("baragund"), __T("barahir"), __T("baran"), __T("baranduin"), __T("bar"), __T("bauglir"),
	__T("beleg"), __T("belegaer"), __T("belegost"), __T("belegund"), __T("beleriand"), 
	__T("belfalas"), __T("belthil"), __T("belthronding"), __T("beor"), __T("beraid"), __T("bereg"), __T("beren"),
	__T("boromir"), __T("boron"), __T("bragollach"), __T("brandir"), __T("bregolas"), __T("bregor"),
	__T("brethil"), __T("brilthor"), __T("brithiach"), __T("brithombar"), __T("brithon"), __T("cabed"),
	__T("calacirya"), __T("calaquendi"), __T("calenardhon"), __T("calion"), __T("camlost"),
	__T("caragdur"), __T("caranthir"), __T("carcharoth"), __T("cardolan"), __T("carnil"),
	__T("celeborn"), __T("celebrant"), __T("celebrimbor"), __T("celebrindal"), __T("celebros"),
	__T("celegorm"), __T("celon"), __T("cirdan"), __T("cirith"), __T("cirth"), __T("ciryatan"),
	__T("ciryon"), __T("coimas"), __T("corollaire"), __T("crissaegrim"), __T("cuarthal"),
	__T("cuivienen"), __T("culurien"), __T("curufin"), __T("curufinwe"), __T("curunir"),
	__T("cuthalion"), __T("daedeloth"), __T("daeron"), __T("dagnir"), __T("dagor"), __T("dagorlad"),
	__T("dairuin"), __T("danwedh"), __T("delduwath"), __T("denethor"), __T("dimbar"), __T("dimrost"),
	__T("dinen"), __T("dior"), __T("dirnen"), __T("dolmed"), __T("doriath"), __T("dorlas"),
	__T("dorthonion"), __T("draugluin"), __T("drengist"), __T("duath"), __T("duinath"), __T("duilwen"),
	__T("dunedain"), __T("dungortheb"), __T("earendil"), __T("earendur"), __T("earnil"), __T("earnur"),
	__T("earrame"), __T("earwen"), __T("echor"), __T("echoriath"), __T("ecthelion"), __T("edain"),
	__T("edrahil"), __T("eglador"), __T("eglarest"), __T("eglath"), __T("eilinel"), __T("eithel"),
	__T("ekkaia"), __T("elbereth"), __T("eldalie"), __T("eldalieva"), __T("eldamar"), __T("eldar"),
	__T("eledhwen"), __T("elemmire"), __T("elende"), __T("elendil"), __T("elendur"), __T("elenna"),
	__T("elentari"), __T("elenwe"), __T("elerrina"), __T("elleth"), __T("elmoth"), __T("elostirion"),
	__T("elrond"), __T("elros"), __T("elu"), __T("eluchil"), __T("elured"), __T("elurin"), __T("elwe"),
	__T("elwing"), __T("emeldir"), __T("endor"), __T("engrin"), __T("engwar"), __T("eol"), __T("eonwe"),
	__T("ephel"), __T("erchamion"), __T("ereb"), __T("ered"), __T("erech"), __T("eregion"), __T("ereinion"),
	__T("erellont"), __T("eressea"), __T("eriador"), __T("eru"), __T("esgalduin"), __T("este"), __T("estel"),
	__T("estolad"), __T("ethir"), __T("ezellohar"), __T("faelivrin"), __T("falas"), __T("falathar"),
	__T("falathrim"), __T("falmari"), __T("faroth"), __T("fauglith"), __T("feanor"), __T("feanturi"),
	__T("felagund"), __T("finarfin"), __T("finduilas"), __T("fingolfin"), __T("fingon"), __T("finwe"),
	__T("firimar"), __T("formenos"), __T("fornost"), __T("frodo"), __T("fuin"), __T("fuinur"),
	__T("gabilgathol"), __T("galad"), __T("galadriel"), __T("galathilion"), __T("galdor"), __T("galen"),
	__T("galvorn"), __T("gandalf"), __T("gaurhoth"), __T("gelion"), __T("gelmir"), __T("gelydh"), __T("gil"),
	__T("gildor"), __T("giliath"), __T("ginglith"), __T("girith"), __T("glaurung"), __T("glingal"),
	__T("glirhuin"), __T("gloredhel"), __T("glorfindel"), __T("golodhrim"), __T("gondolin"),
	__T("gondor"), __T("gonnhirrim"), __T("gorgoroth"), __T("gorlim"), __T("gorthaur"), __T("gorthol"),
	__T("gothmog"), __T("guilin"), __T("guinar"), __T("guldur"), __T("gundor"), __T("gurthang"),
	__T("gwaith"), __T("gwareth"), __T("gwindor"), __T("hadhodrond"), __T("hador"), __T("haladin"),
	__T("haldad"), __T("haldan"), __T("haldar"), __T("haldir"), __T("haleth"), __T("halmir"), __T("handir"),
	__T("harad"), __T("hareth"), __T("hathaldir"), __T("hathol"), __T("haudh"), __T("helcar"),
	__T("helcaraxe"), __T("helevorn"), __T("helluin"), __T("herumor"), __T("herunumen"),
	__T("hildorien"), __T("himlad"), __T("himring"), __T("hirilorn"), __T("hisilome"),
	__T("hithaeglir"), __T("hithlum"), __T("hollin"), __T("huan"), __T("hunthor"), __T("huor"), __T("hurin"),
	__T("hyarmendacil"), __T("hyarmentir"), __T("iant"), __T("iaur"), __T("ibun"), __T("idril"),
	__T("illuin"), __T("ilmare"), __T("ilmen"), __T("iluvatar"), __T("imlach"), __T("imladris"), __T("indis"),
	__T("ingwe"), __T("irmo"), __T("isil"), __T("isildur"), __T("istari"), __T("ithil"), __T("ivrin"),
	__T("kelvar"), __T("kementari"), __T("ladros"), __T("laiquendi"), __T("lalaith"), __T("lamath"),
	__T("lammoth"), __T("lanthir"), __T("laurelin"), __T("leithian"), __T("legolin"), __T("lembas"),
	__T("lenwe"), __T("linaewen"), __T("lindon"), __T("lindorie"), __T("loeg"), __T("lomelindi"),
	__T("lomin"), __T("lomion"), __T("lorellin"), __T("lorien"), __T("lorindol"), __T("losgar"),
	__T("lothlann"), __T("lothlorien"), __T("luin"), __T("luinil"), __T("lumbar"), __T("luthien"),
	__T("mablung"), __T("maedhros"), __T("maeglin"), __T("maglor"), __T("magor"), __T("mahanaxar"),
	__T("mahtan"), __T("maiar"), __T("malduin"), __T("malinalda"), __T("mandos"), __T("manwe"), __T("mardil"),
	__T("melian"), __T("melkor"), __T("menegroth"), __T("meneldil"), __T("menelmacar"),
	__T("meneltarma"), __T("minas"), __T("minastir"), __T("mindeb"), __T("mindolluin"), __T("mindon"),
	__T("minyatur"), __T("mirdain"), __T("miriel"), __T("mithlond"), __T("mithrandir"), __T("mithrim"),
	__T("mordor"), __T("morgoth"), __T("morgul"), __T("moria"), __T("moriquendi"), __T("mormegil"),
	__T("morwen"), __T("nahar"), __T("naeramarth"), __T("namo"), __T("nandor"), __T("nargothrond"),
	__T("narog"), __T("narsil"), __T("narsilion"), __T("narya"), __T("nauglamir"), __T("naugrim"),
	__T("ndengin"), __T("neithan"), __T("neldoreth"), __T("nenar"), __T("nenning"), __T("nenuial"),
	__T("nenya"), __T("nerdanel"), __T("nessa"), __T("nevrast"), __T("nibin"), __T("nienna"), __T("nienor"),
	__T("nimbrethil"), __T("nimloth"), __T("nimphelos"), __T("nimrais"), __T("nimras"),
	__T("ningloron"), __T("niniel"), __T("ninniach"), __T("ninquelote"), __T("niphredil"),
	__T("nirnaeth"), __T("nivrim"), __T("noegyth"), __T("nogrod"), __T("noldolante"), __T("noldor"),
	__T("numenor"), __T("nurtale"), __T("obel"), __T("ohtar"), __T("oiolosse"), __T("oiomure"), __T("olorin"),
	__T("olvar"), __T("olwe"), __T("ondolinde"), __T("orfalch"), __T("ormal"), __T("orocarni"),
	__T("orodreth"), __T("orodruin"), __T("orome"), __T("oromet"), __T("orthanc"), __T("osgiliath"),
	__T("osse"), __T("ossiriand"), __T("palantir"), __T("pelargir"), __T("pelori"), __T("periannath"),
	__T("quendi"), __T("quenta"), __T("quenya"), __T("radagast"), __T("radhruin"), __T("ragnor"),
	__T("ramdal"), __T("rana"), __T("rathloriel"), __T("rauros"), __T("region"), __T("rerir"),
	__T("rhovanion"), __T("rhudaur"), __T("rhun"), __T("rhunen"), __T("rian"), __T("ringil"), __T("ringwil"),
	__T("romenna"), __T("rudh"), __T("rumil"), __T("saeros"), __T("salmar"), __T("saruman"), __T("sauron"),
	__T("serech"), __T("seregon"), __T("serinde"), __T("shelob"), __T("silmarien"), __T("silmaril"),
	__T("silpion"), __T("sindar"), __T("singollo"), __T("sirion"), __T("soronume"), __T("sul"), __T("sulimo"),
	__T("talath"), __T("taniquetil"), __T("tar"), __T("taras"), __T("tarn"), __T("tathren"), __T("taur"),
	__T("tauron"), __T("teiglin"), __T("telchar"), __T("telemnar"), __T("teleri"), __T("telperion"),
	__T("telumendil"), __T("thalion"), __T("thalos"), __T("thangorodrim"), __T("thargelion"),
	__T("thingol"), __T("thoronath"), __T("thorondor"), __T("thranduil"), __T("thuringwethil"),
	__T("tilion"), __T("tintalle"), __T("tinuviel"), __T("tirion"), __T("tirith"), __T("tol"), __T("tulkas"),
	__T("tumhalad"), __T("tumladen"), __T("tuna"), __T("tuor"), __T("turambar"), __T("turgon"), __T("turin"),
	__T("uial"), __T("uilos"), __T("uinen"), __T("ulairi"), __T("ulmo"), __T("ulumuri"), __T("umanyar"),
	__T("umarth"), __T("umbar"), __T("ungoliant"), __T("urthel"), __T("uruloki"), __T("utumno"), __T("vaire"),
	__T("valacirca"), __T("valandil"), __T("valaquenta"), __T("valar"), __T("valaraukar"),
	__T("valaroma"), __T("valier"), __T("valimar"), __T("valinor"), __T("valinoreva"), __T("valmar"),
	__T("vana"), __T("vanyar"), __T("varda"), __T("vasa"), __T("vilya"), __T("vingilot"), __T("vinyamar"),
	__T("voronwe"), __T("wethrin"), __T("wilwarin"), __T("yavanna"),
	NULL
};

/* These are (mostly) picked at random from a Latin word list. */
static const _TCHAR *scroll_names[] =
{
	__T("abracadabra"), __T("piffpaffpouf"), __T("izzy"), __T("wizzy"), __T("letsgetsbusy"),
	__T("justlikethat"), __T("hocus"), __T("pocus"), __T("shazam"), __T("please"), __T("abduco"),
	__T("absorbeo"), __T("abutor"), __T("accipio"), __T("acerbus"), __T("adamo"), __T("adeo"), __T("adficio"),
	__T("adinventitias"), __T("admitto"), __T("adsidue"), __T("adsumo"), __T("advenio"), __T("aeger"),
	__T("aegrus"), __T("aestivus"), __T("aggero"), __T("ago"), __T("alioqui"), __T("aliquantum"),
	__T("aliquot"), __T("alter"), __T("ambianis"), __T("amissio"), __T("amoveo"), __T("andegavense"),
	__T("animus"), __T("antepono"), __T("appareo"), __T("appropinquo"), __T("ara"), __T("arca"), __T("arguo"),
	__T("articulus"), __T("ascit"), __T("astrum"), __T("atrebatum"), __T("attonbitus"), __T("audax"),
	__T("aureus"), __T("autus"), __T("averto"), __T("bardus"), __T("bene"), __T("bibo"), __T("bonus"),
	__T("breviter"), __T("calamitas"), __T("callidus"), __T("canonus"), __T("caput"), __T("caritas"),
	__T("casso"), __T("catervatim"), __T("causa"), __T("cedo"), __T("celeriter"), __T("centum"),
	__T("certus"), __T("charisma"), __T("cimentarius"), __T("cito"), __T("clamor"), __T("claustrum"),
	__T("coerceo"), __T("cogo"), __T("colloco"), __T("coma"), __T("cometissa"), __T("commeo"),
	__T("commissum"), __T("commoneo"), __T("compatior"), __T("compes"), __T("compositio"),
	__T("comprovincialis"), __T("concido"), __T("conculco"), __T("condico"), __T("confiteor"),
	__T("conicio"), __T("conor"), __T("conservo"), __T("consisto"), __T("constans"), __T("construo"),
	__T("consueta"), __T("consulto"), __T("consuo"), __T("contamino"), __T("contemptio"),
	__T("contentus"), __T("contineo"), __T("contradictio"), __T("conventus"), __T("copiose"),
	__T("corrigo"), __T("corturiacum"), __T("crastinus"), __T("creo"), __T("cribrum"), __T("cruentus"),
	__T("cubicularius"), __T("cui"), __T("culpa"), __T("cum"), __T("cunctus"), __T("cur"), __T("curiosus"),
	__T("currus"), __T("curto"), __T("custodiae"), __T("debeo"), __T("decimus"), __T("decumbo"),
	__T("defendo"), __T("defleo"), __T("degenero"), __T("delego"), __T("delinquo"), __T("demonstro"),
	__T("dens"), __T("depono"), __T("deprecor"), __T("derelinquo"), __T("desino"), __T("despero"),
	__T("detego"), __T("devito"), __T("diabolus"), __T("didicerat"), __T("differo"), __T("dignitas"),
	__T("dilabor"), __T("diluculo"), __T("diripio"), __T("disco"), __T("dissimilis"), __T("districtus"),
	__T("diutius"), __T("divitiae"), __T("dolens"), __T("domesticus"), __T("donec"), __T("duco"),
	__T("dulcidine"), __T("duro"), __T("ecclesia"), __T("edo"), __T("efficio"), __T("ego"), __T("elemosina"),
	__T("eluvies"), __T("emineo"), __T("emptio"), __T("epistula"), __T("equus"), __T("erogo"), __T("erudio"),
	__T("etsi"), __T("ex"), __T("excito"), __T("excuso"), __T("exesto"), __T("exhorresco"), __T("eximo"),
	__T("exorior"), __T("experior"), __T("expiscor"), __T("explico"), __T("exsequor"), __T("exstinguo"),
	__T("extra"), __T("fabula"), __T("facio"), __T("faenum"), __T("famulus"), __T("fautor"), __T("felix"),
	__T("ferme"), __T("festinus"), __T("fides"), __T("fines"), __T("flamma"), __T("fluo"), __T("formo"),
	__T("fortiter"), __T("foveo"), __T("frequentia"), __T("frugalitas"), __T("fuga"), __T("fultus"),
	__T("furor"), __T("galea"), __T("genus"), __T("glacialis"), __T("gratia"), __T("gravatus"),
	__T("gregatim"), __T("hactenus"), __T("harum"), __T("heniis"), __T("hic"), __T("his"), __T("hoc"),
	__T("honorabilis"), __T("horum"), __T("huic"), __T("humanitas"), __T("hunnam"), __T("iam"), __T("idem"),
	__T("ignavus"), __T("illa"), __T("illarum"), __T("illi"), __T("illis"), __T("illius"), __T("illorum"),
	__T("illum"), __T("imitor"), __T("immortalis"), __T("impedito"), __T("impendo"), __T("imperium"),
	__T("importunus"), __T("ex"), __T("in"), __T("incertus"), __T("includo"), __T("incorruptus"), __T("inda"),
	__T("indignatio"), __T("induco"), __T("inexpugnabilis"), __T("infecunditas"), __T("infenso"),
	__T("infero"), __T("inficio"), __T("infigo"), __T("infirmitas"), __T("infitior"), __T("inflatus"),
	__T("infligo"), __T("infortunatus"), __T("ingemuo"), __T("inicio"), __T("innotesco"), __T("inquis"),
	__T("insciens"), __T("insidiae"), __T("insperatus"), __T("instructus"), __T("insurgo"),
	__T("intentio"), __T("interdum"), __T("intueor"), __T("invado"), __T("invetero"), __T("invisus"),
	__T("ipsemet"), __T("irritus"), __T("ita"), __T("iucunditas"), __T("iugis"), __T("iussu"), __T("jaculum"),
	__T("juventus"), __T("labiosus"), __T("laboriose"), __T("labruscum"), __T("lacertosus"),
	__T("lacrimo"), __T("lacto"), __T("laedo"), __T("laetificus"), __T("laevus"), __T("lamentatio"),
	__T("laqueus"), __T("laudo"), __T("lectus"), __T("lemiscus"), __T("lenitas"), __T("lentesco"), __T("leo"),
	__T("lesciense"), __T("leto"), __T("levidensis"), __T("levo"), __T("liber"), __T("libere"), __T("licet"),
	__T("lino"), __T("loci"), __T("longe"), __T("lucerna"), __T("ludio"), __T("lupus"), __T("macero"),
	__T("maculo"), __T("maero"), __T("magus"), __T("malmundarium"), __T("mandatum"), __T("manus"),
	__T("matera"), __T("me"), __T("mei"), __T("memor"), __T("mensa"), __T("meridianus"), __T("mica"),
	__T("millies"), __T("minuo"), __T("miser"), __T("mitigo"), __T("modio"), __T("molestia"),
	__T("monasteriense"), __T("monstrum"), __T("morior"), __T("moveo"), __T("multo"), __T("mundus"),
	__T("munus"), __T("mutuo"), __T("nascor"), __T("navigo"), __T("necesse"), __T("nemo"), __T("neque"),
	__T("niger"), __T("nisi"), __T("nivellensem"), __T("noceo"), __T("non"), __T("nos"), __T("nota"), __T("novus"),
	__T("nunc"), __T("nusquam"), __T("obdormio"), __T("oblivio"), __T("obviam"), __T("occupo"), __T("odium"),
	__T("omitto"), __T("onus"), __T("oporotheca"), __T("opportunitatus"), __T("ops"), __T("orator"),
	__T("orior"), __T("ostium"), __T("pactum"), __T("palam"), __T("par"), __T("parens"), __T("paro"),
	__T("passer"), __T("patiens"), __T("patruus"), __T("pax"), __T("pecus"), __T("penitus"), __T("per"),
	__T("percutio"), __T("perfectus"), __T("periclitatus"), __T("periurium"), __T("perpetro"),
	__T("perseverantia"), __T("persuadeo"), __T("pertineo"), __T("peruro"), __T("pessimus"),
	__T("pestis"), __T("phasma"), __T("pictoratus"), __T("pirus"), __T("placide"), __T("plagiarius"),
	__T("plecto"), __T("plico"), __T("pluma"), __T("plures"), __T("pluvia"), __T("polenta"), __T("pomum"),
	__T("porta"), __T("postea"), __T("postulo"), __T("potius"), __T("praebeo"), __T("praecido"),
	__T("praeda"), __T("praefinio"), __T("praenuntio"), __T("praesentia"), __T("praesto"),
	__T("praetereo"), __T("pravitas"), __T("premo"), __T("primitus"), __T("principatus"), __T("prius"),
	__T("pro"), __T("procedo"), __T("procurator"), __T("proficio"), __T("profor"), __T("progenero"),
	__T("progressio"), __T("proinde"), __T("prolecto"), __T("proloquor"), __T("prominens"),
	__T("promitto"), __T("promptu"), __T("promus"), __T("propello"), __T("propositum"), __T("prorsus"),
	__T("prosum"), __T("proveho"), __T("prudens"), __T("pudendus"), __T("puerilis"), __T("pugnax"),
	__T("pulex"), __T("pulpa"), __T("pumilius"), __T("punitor"), __T("purgatio"), __T("puteo"),
	__T("pyropus"), __T("quadrigae"), __T("quae"), __T("quaesitio"), __T("qualiscumque"), __T("quam"),
	__T("quando"), __T("quantum"), __T("quantuslibet"), __T("quas"), __T("quater"), __T("quercus"),
	__T("queror"), __T("quibus"), __T("quicquid"), __T("quin"), __T("quisnam"), __T("quo"), __T("quodammodo"),
	__T("quorum"), __T("radicitus"), __T("recedo"), __T("recolo"), __T("rectum"), __T("redarguo"),
	__T("redeo"), __T("refectorium"), __T("rego"), __T("relinquo"), __T("remaneo"), __T("rependo"),
	__T("repeto"), __T("reprehendo"), __T("resisto"), __T("retraho"), __T("revoco"), __T("rigor"),
	__T("rotomagense"), __T("rursus"), __T("sacrilegus"), __T("saeta"), __T("saluto"),
	__T("sanctimonialis"), __T("sanitas"), __T("sapienter"), __T("satis"), __T("scaldus"), __T("scelus"),
	__T("scio"), __T("se"), __T("secundum"), __T("secus"), __T("seductor"), __T("sententia"),
	__T("sepulchrum"), __T("sermo"), __T("servus"), __T("siccus"), __T("silens"), __T("silva"),
	__T("simulatio"), __T("singultus"), __T("sive"), __T("soleo"), __T("sollicitudo"), __T("solum"),
	__T("somnio"), __T("sopor"), __T("speciosus"), __T("spero"), __T("spolium"), __T("statim"), __T("stipes"),
	__T("studio"), __T("sub"), __T("subseco"), __T("succendo"), __T("suggero"), __T("summissus"),
	__T("super"), __T("superne"), __T("suppellex"), __T("suppono"), __T("suscito"), __T("tabellae"),
	__T("tactus"), __T("tam"), __T("tandem"), __T("taruennam"), __T("tempero"), __T("templum"), __T("tendo"),
	__T("tenus"), __T("teres"), __T("tergum"), __T("tero"), __T("tertius"), __T("textor"), __T("thema"),
	__T("thymbra"), __T("titulus"), __T("torqueo"), __T("toties"), __T("traiectum"), __T("trellum"),
	__T("tricesimus"), __T("tristis"), __T("tubineus"), __T("tungris"), __T("turpe"), __T("ubi"),
	__T("ultra"), __T("undique"), __T("unus"), __T("usque"), __T("ut"), __T("utilitas"), __T("utroque"),
	__T("vado"), __T("validus"), __T("vehementer"), __T("vendolius"), __T("ventus"), __T("verecundia"),
	__T("versus"), __T("vesica"), __T("vestio"), __T("vicissitudo"), __T("video"), __T("vilicus"),
	__T("vindico"), __T("virga"), __T("vis"), __T("vivo"), __T("voco"), __T("volo"), __T("voluntas"), __T("volva"),
	__T("voro"), __T("vulariter"), __T("vulnus"), __T("vultus"),
	NULL
};

/* Markers for the start and end of words. */
#define S_WORD 26
#define E_WORD S_WORD
#define TOTAL  27

typedef unsigned short name_probs[S_WORD+1][S_WORD+1][TOTAL+1];

/*
 * This function builds probability tables from a list of purely alphabetical
 * lower-case words, and puts them into the supplied name_probs object.
 * The array of names should have a NULL entry at the end of the list.
 * It relies on the ASCII character set (through use of A2I).
 */
static void build_prob(name_probs probs, const _TCHAR **learn)
{
	int c_prev, c_cur, c_next;
	const _TCHAR *ch;
	int i;

	/* Build raw frequencies */
	for (i = 0; learn[i] != NULL; i++)
	{
		c_prev = c_cur = S_WORD;
		ch = learn[i];

		/* Iterate over the next word */
		while (*ch != 0)
		{
			c_next = A2I(_totlower(*ch));

			probs[c_prev][c_cur][c_next]++;
			probs[c_prev][c_cur][TOTAL]++;
                        
			/* Step on */
			c_prev = c_cur;
			c_cur = c_next;
			ch++;
		}

		probs[c_prev][c_cur][E_WORD]++;
		probs[c_prev][c_cur][TOTAL]++;
	}
}

/*
 * Use W. Sheldon Simms' random name generator algorithm (Markov Chain stylee).
 * 
 * Generate a random word using the probability tables we built earlier.  
 * Relies on the A2I and I2A macros (and so the ASCII character set) and 
 * is_a_vowel (so the basic 5 English vowels).
 */
size_t randname_make(randname_type name_type, size_t min, size_t max, _TCHAR *word_buf, size_t buflen)
{
	size_t lnum = 0;
	bool found_word = FALSE;

	static name_probs lprobs;
	static randname_type cached_type = RANDNAME_NUM_TYPES;

	assert(name_type > 0 && name_type < RANDNAME_NUM_TYPES);

	/* To allow for a terminating character */
	assert(buflen > max);

	/* We cache one set of probabilities, only regenerate when
	   the type changes.  It's as good a way as any for now.
	   Frankly, we could probably regenerate every time. */
	if (cached_type != name_type)
	{
		const _TCHAR **wordlist = NULL;

		switch (name_type)
		{
			case RANDNAME_TOLKIEN:
			{
				wordlist = tolkien_names;
				break;
			}
			case RANDNAME_SCROLL:
			{
				wordlist = scroll_names;
				break;
			}
			case RANDNAME_NUM_TYPES:
			{
				/* Unreachable - stops compiler warning */
			}
		}
		build_prob(lprobs, wordlist);
		cached_type = name_type;
	}
	/* Generate the actual word wanted. */
	while (!found_word)
	{
		_TCHAR *cp = word_buf;
		int c_prev = S_WORD;
		int c_cur = S_WORD;
		int tries = 0;
		bool contains_vowel = FALSE;
		lnum = 0;

		/* We start the word again if we run out of space or have
		   had to have 10 goes to find a word that satisfies the
		   minimal conditions. */
		while (tries < 10 && lnum <= max && !found_word)
		{
			/* Pick the next letter based on a simple weighting
			  of which letters can follow the previous two */
			int r = randint0(lprobs[c_prev][c_cur][TOTAL]);
			int c_next = 0;

			while (r >= lprobs[c_prev][c_cur][c_next])
			{
				r -= lprobs[c_prev][c_cur][c_next];
				c_next++;
			}
			if (c_next == E_WORD)
			{
				/* If we've reached the end, we check if we've
				   met the simple conditions, otherwise have
				   another go at choosing a letter for this
				   position. */
				if (lnum >= min && contains_vowel)
				{
					*cp = 0;
					found_word = TRUE;
				}
				else
				{
					tries++;
				}
			}
			else
			{
				/* Add the letter to the word and move on. */
				*cp = I2A(c_next);

				if (is_a_vowel(*cp))
					contains_vowel = TRUE;

				cp++;
				lnum++;
				c_prev = c_cur;
				c_cur = c_next;
			}
		}
	}
	return lnum;
}

/* 
 * To run standalone tests, #define RANDNAME_TESTING and link with
 *  with just z-rand.c from Angband. 
 */
#ifdef RANDNAME_TESTING

#include <stdio.h>
#include <time.h>

bool is_a_vowel(int ch)
{
	switch (ch)
	{
		case 'a':
		case 'e':
		case 'i':
		case 'o':
		case 'u':
			 return (TRUE);
	}

	return (FALSE);
}

int main(int argc, char *argv[])
{
	int i;
	_TCHAR name[256];

	Rand_value = time(NULL);

	for (i = 0; i < 20; i++)
	{
		randname_make(RANDNAME_TOLKIEN, 5, 9, name, 256);
		name[0] = _totupper(name[0]);
		printf(L"%s\n", name);
	}

	return 0;
}

#endif
