/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_HINADI_H__
#define __KZ_HINADI_H__

#include <glib-object.h>
#include "kz-meta.h"

G_BEGIN_DECLS

#define KZ_TYPE_HINADI		(kz_hinadi_get_type ())
#define KZ_HINADI(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_HINADI, KzHINADI))
#define KZ_HINADI_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_HINADI, KzHINADIClass))
#define KZ_IS_HINADI(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_HINADI))
#define KZ_IS_HINADI_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_HINADI))
#define KZ_HINADI_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_HINADI, KzHINADIClass))

typedef struct _KzHINADI KzHINADI;
typedef struct _KzHINADIClass KzHINADIClass;

struct _KzHINADI
{
	KzMETA parent;
	gchar *antenna_uri;
};

struct _KzHINADIClass
{
	KzMETAClass parent_class;
};

GType  kz_hinadi_get_type (void);
KzHINADI *kz_hinadi_new (gchar *uri, gchar *title, guint update_interval);

G_END_DECLS

#endif /* __KZ_HINADI_H__ */
