/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_LIRS_H__
#define __KZ_LIRS_H__

#include <glib-object.h>
#include "kz-meta.h"

G_BEGIN_DECLS

#define KZ_TYPE_LIRS		(kz_lirs_get_type ())
#define KZ_LIRS(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_LIRS, KzLIRS))
#define KZ_LIRS_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_LIRS, KzLIRSClass))
#define KZ_IS_LIRS(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_LIRS))
#define KZ_IS_LIRS_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_LIRS))
#define KZ_LIRS_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_LIRS, KzLIRSClass))

typedef struct _KzLIRS KzLIRS;
typedef struct _KzLIRSClass KzLIRSClass;

struct _KzLIRS
{
	KzMETA parent;
	gchar *antenna_uri;
};

struct _KzLIRSClass
{
	KzMETAClass parent_class;
};

GType  kz_lirs_get_type (void);
KzLIRS *kz_lirs_new (gchar *uri, gchar *title, guint update_interval);

G_END_DECLS

#endif /* __KZ_LIRS_H__ */
