/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_META_H__
#define __KZ_META_H__

#include <glib-object.h>
#include "kz-window.h"

G_BEGIN_DECLS

#define KZ_TYPE_META		(kz_meta_get_type ())
#define KZ_META(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_META, KzMETA))
#define KZ_META_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_META, KzMETAClass))
#define KZ_IS_META(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_META))
#define KZ_IS_META_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_META))
#define KZ_META_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_META, KzMETAClass))

typedef struct _KzMETA KzMETA;
typedef struct _KzMETAClass KzMETAClass;
typedef struct _KzMETAItem KzMETAItem;
typedef struct _KzMETAItems KzMETAItems;

typedef enum {
	KZ_META_NORMAL,
	KZ_META_LOADING,
} KzMETAState;

struct _KzMETA
{
	GObject parent;
	
	gchar *title;
	/* uri of meta file */
	gchar *uri;

	/* update timer id */
	guint timer_id;
	/* update interval minutes */
	guint  update_interval;
	/* meta items */
	GSList *items;

	KzMETAState state;
};

struct _KzMETAClass
{
	GObjectClass parent_class;

	/* -- signals -- */
	void (*update_start)         (KzMETA *meta);
	void (*update_completed)     (KzMETA *meta);

	void (*kz_meta_parse_from_string) (KzMETA *meta, gpointer user_data,
					   const gchar *buffer, guint length,
					   GError **error);

};

struct _KzMETAItem
{
	KzMETA *meta;

	gchar *title;
	gchar *link;
	gchar *description;
	guint date;
};

GType  kz_meta_get_type (void);
KzMETA *kz_meta_new     (gchar *uri,
			 gchar *title,
			 guint  update_interval);
void   kz_meta_start    (KzMETA *meta);

void   kz_meta_force_update  (KzMETA *meta);

gboolean kz_meta_update      (KzMETA *meta);
void     kz_meta_dispose     (GObject *object);

void kz_meta_set_interval (KzMETA *meta,
			   guint   interval); /* [min] */

G_END_DECLS

#endif /* __KZ_META_H__ */
