/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "gtkmozembed.h"

#include "kazehakase-type.h"
#include "kazehakase.h"

/* XPM */
static char * small_close[] = {
"8 9 17 1",
" 	c None",
".	c #020302",
"+	c #22262A",
"@	c #626466",
"#	c #828486",
"$	c #A6A2AE",
"%	c #AEAAB6",
"&	c #B6B2BE",
"*	c #BEBAC6",
"=	c #EEEEF2",
"-	c #424242",
";	c #121212",
">	c #4E5052",
",	c #FEFEFE",
"'	c #72767A",
")	c #6A6E72",
"!	c #1A1A1A",
"        ",
" &  *%  ",
" >#=+;$ ",
"  .>.@  ",
"  @.-   ",
"  -..'  ",
" &;#!.) ",
" >$ %;> ",
"        "};

void kazehakase_tab_close_cb (GtkWidget *button, KazehakaseEmbed *kzembed)
{
	kazehakase_tab_close(kzembed);
}

void kazehakase_tab_close (KazehakaseEmbed *kzembed)
{
	Kazehakase *kz = kzembed->parent_kazehakase;
	
	gint n = gtk_notebook_page_num(GTK_NOTEBOOK(kz->notebook),
				       GTK_WIDGET(kzembed->mozembed));
	gtk_notebook_remove_page(GTK_NOTEBOOK(kz->notebook), n);
	g_free(kzembed);
	if (gtk_notebook_get_n_pages(GTK_NOTEBOOK(kz->notebook)) == 0)
	{
		gtk_moz_embed_pop_startup();
		gtk_widget_destroy(kz->topLevelWindow);
		gtk_main_quit();
	}
	else
	  gtk_notebook_set_current_page(GTK_NOTEBOOK(kz->notebook), n);
}

KazehakaseEmbed *kazehakase_tab_new (Kazehakase *kz, gchar *url)
{
	GtkWidget *hbox, *pixmap, *button;
	GdkPixmap *gdkpixmap;
	GdkBitmap *mask;
	KazehakaseEmbed *kzembed;

	kzembed = g_new0(KazehakaseEmbed, 1);	
	kzembed->parent_kazehakase = kz;
	kzembed->mozembed = GTK_MOZ_EMBED(gtk_moz_embed_new());
	gtk_moz_embed_load_url(GTK_MOZ_EMBED(kzembed->mozembed), url);
	
     	hbox = gtk_hbox_new(0, 0);
	
	/* tab label */
	kzembed->notebook_label = gtk_label_new("no_title");
	gtk_widget_set_size_request(kzembed->notebook_label, 50, -1);
	button = gtk_button_new();
	gtk_widget_set_usize(button, 14, 14);
	gtk_button_set_relief((GtkButton *) button, GTK_RELIEF_NONE);
	
	gdkpixmap = gdk_pixmap_colormap_create_from_xpm_d(kz->topLevelWindow->window,gtk_widget_get_colormap(hbox),&mask,NULL,small_close);
	pixmap = gtk_image_new_from_pixmap(gdkpixmap,mask);
	gdk_pixmap_unref(gdkpixmap);
	gdk_bitmap_unref(mask);
	gtk_container_add(GTK_CONTAINER(button), pixmap);
	g_signal_connect(G_OBJECT(button), "clicked", 
			 G_CALLBACK(kazehakase_tab_close_cb), kzembed);
	
	gtk_box_pack_start(GTK_BOX(hbox), kzembed->notebook_label, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);

	gtk_widget_show_all(hbox);
	
	gtk_notebook_append_page(GTK_NOTEBOOK(kz->notebook),
				 GTK_WIDGET(kzembed->mozembed),
				 hbox);
/*	kz->kzembed_list = g_list_append(kz->kzembed_list, kzembed); */
/*
	for (i = 0; signal_connections[i].event != NULL; i++) {
		g_signal_connect(G_OBJECT(browser->embed),
				   signal_connections[i].event,
				   signal_connections[i].func, kzembed);
	}*/
	g_signal_connect(G_OBJECT(kzembed->mozembed), "title",
			 G_CALLBACK(title_changed_cb), kzembed);
	g_signal_connect(G_OBJECT(kzembed->mozembed), "location",
			 G_CALLBACK(location_changed_cb), kzembed);
	g_signal_connect(G_OBJECT(kzembed->mozembed), "new_window",
			 G_CALLBACK(new_window_cb), kzembed);
	g_signal_connect(G_OBJECT(kzembed->mozembed), "link_message",
			 G_CALLBACK(link_message_cb), kzembed);
	/* key event signals */
	g_signal_connect(G_OBJECT(kzembed->mozembed), "dom_key_press",
			 G_CALLBACK(dom_key_press_cb), kzembed);
	g_signal_connect(G_OBJECT(kzembed->mozembed), "dom_key_down",
			   G_CALLBACK(dom_key_down_cb), kzembed);
	g_signal_connect(G_OBJECT(kzembed->mozembed), "dom_key_up",
			   G_CALLBACK(dom_key_up_cb), kzembed);
	/* mouse event signal */
	g_signal_connect(G_OBJECT(kzembed->mozembed), "dom_mouse_click",
			   G_CALLBACK(dom_mouse_click_cb), kzembed);
	g_signal_connect(G_OBJECT(kzembed->mozembed), "dom_mouse_dbl_click",
			 G_CALLBACK(dom_mouse_dbl_click_cb), kzembed);
	g_signal_connect(G_OBJECT(kzembed->mozembed), "dom_mouse_down",
			   G_CALLBACK(dom_mouse_down_cb), kzembed);
	g_signal_connect(G_OBJECT(kzembed->mozembed), "dom_mouse_up",
			   G_CALLBACK(dom_mouse_up_cb), kzembed);
//	g_signal_connect(G_OBJECT(kzembed->mozembed), "dom_mouse_over",
//			 G_CALLBACK(dom_mouse_over_cb), kzembed);
//	g_signal_connect(G_OBJECT(kzembed->mozembed), "dom_mouse_out",
//			   G_CALLBACK(dom_mouse_out_cb), kzembed);
//	g_signal_connect(G_OBJECT(kzembed->mozembed), "visibility",
//			 G_CALLBACK(visibility_cb), kzembed);
	// hook up the start and stop signals
	// hook up to the change in network status
	g_signal_connect(G_OBJECT(kzembed->mozembed), "net_start",
			 G_CALLBACK(load_started_cb), kzembed);
	g_signal_connect(G_OBJECT(kzembed->mozembed), "net_stop",
			 G_CALLBACK(load_finished_cb), kzembed);
/*	g_signal_connect(G_OBJECT(kzembed->mozembed), "net_state",
			 G_CALLLBCK(net_state_change_cb), kzembed);
	g_signal_connect(G_OBJECT(kzembed->mozembed), "net_state_all",
			   G_CALLBACK(net_state_change_all_cb), kzembed);
*/	// hookup to changes in progress
/*	g_signal_connect(G_OBJECT(kzembed->mozembed), "progress",
			   G_CALLBACK(progress_change_cb), kzembed);
	g_signal_connect(G_OBJECT(kzembed->mozembed), "progress_all",
			   G_CALLBACK(progress_change_all_cb), kzembed);
*/	// hookup to changes in js status message
//	g_signal_connect(G_OBJECT(kzembed->mozembed), "js_status",
//			   G_CALLBACK(js_status_cb), kzembed);
	// hookup to the signal that says that the kzembed requested to be
	// destroyed
//	g_signal_connect(G_OBJECT(kzembed->mozembed), "destroy_browser",
//			   G_CALLBACK(destroy_brsr_cb), kzembed);
	// hookup to the signal that is called when someone clicks on a link
	// to load a new uri
	g_signal_connect(G_OBJECT(kzembed->mozembed), "open_uri",
			 G_CALLBACK(open_uri_cb), kzembed);
	// this signal is emitted when there's a request to change the
	// containing kzembed window to a certain height, like with width
	// and height args for a window.open in javascript
	g_signal_connect(G_OBJECT(kzembed->mozembed), "size_to",
			   G_CALLBACK(size_to_cb), kzembed);
	// hookup to when the window is destroyed
//	g_signal_connect(G_OBJECT(kzembed->mozembed), "destroy",
//			   G_CALLBACK(destroy_cb), kzembed);
  
	// set the chrome type so it's stored in the object
//	g_moz_embed_set_chrome_mask(GTK_MOZ_EMBED(kzembed->mozembed),
//				      actualChromeMask);
	gtk_widget_show(GTK_WIDGET(kzembed->mozembed));
	
	return kzembed;
}
