/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
typedef struct _Kazehakase Kazehakase;
typedef struct _KazehakaseEmbed KazehakaseEmbed;

struct _Kazehakase 
{
	GtkWidget  *topLevelWindow;
	GtkWidget  *topLevelVBox;
	GtkWidget  *menuBar;
	GtkWidget  *fileMenuItem;
	GtkWidget  *fileMenu;
	GtkWidget  *fileClose;
	GtkWidget  *fileQuit;
	GtkWidget  *toolbarHBox;
	GtkWidget  *toolbar;
	GtkWidget  *backButton;
	GtkWidget  *stopButton;
	GtkWidget  *forwardButton;
	GtkWidget  *reloadButton;
	GtkWidget  *homeButton;
	GtkWidget  *urlEntry;
	GtkWidget  *progressAreaHBox;
	GtkWidget  *progressBar;
	GtkWidget  *statusAlign;
	GtkWidget  *statusBar;
	GtkWidget  *notebook;
	GtkWidget  *findAreaHBox;
	GtkWidget  *findArea;
/*	GList      *kzembed_list; */
	const char *statusMessage;
	char       *tempMessage;
	gboolean   menuBarOn;
	gboolean   toolBarOn;
	gboolean   locationBarOn;
	gboolean   statusBarOn;
};

struct _KazehakaseEmbed
{
	/* Kazehakase */
	Kazehakase *parent_kazehakase;

	/* embedding widget */
	GtkMozEmbed *mozembed;

	/* tab widgets */
	GtkWidget *notebook_hbox;                /* packing box           */
	GtkWidget *notebook_label;               /* the label             */
	GtkWidget *notebook_close_button;        /* active close button   */

	/* location and title */
	gchar *location;
	gchar *title;

	gint load_started; /* count of currently active connections */
	gint load_percent;
	gint bytes_loaded;
	gint max_bytes_loaded;
	int  is_loading;
	const gchar *load_status_message;
	
	/* mouse gesture */
	gint gesture;
	gint x;
	gint y;
};

