/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_BOOKMARK_BAR_H__
#define __KZ_BOOKMARK_BAR_H__

#include "kz-window.h"

G_BEGIN_DECLS

#define KZ_TYPE_BOOKMARK_BAR		(kz_bookmark_bar_get_type ())
#define KZ_BOOKMARK_BAR(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BOOKMARK_BAR, KzBookmarkBar))
#define KZ_BOOKMARK_BAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_BOOKMARK_BAR, KzBookmarkBarClass))
#define KZ_IS_BOOKMARK_BAR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BOOKMARK_BAR))
#define KZ_IS_BOOKMARK_BAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_BOOKMARK_BAR))
#define KZ_BOOKMARK_BAR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_BOOKMARK_BAR, KzBookmarkBarClass))

typedef struct _KzBookmarkBar KzBookmarkBar;
typedef struct _KzBookmarkBarClass KzBookmarkBarClass;

struct _KzBookmarkBar
{
	GtkToolbar parent;

	KzWindow *parent_kazehakase;
	GSList *items;
};

struct _KzBookmarkBarClass
{
	GtkToolbarClass parent_class;
};

GtkType    kz_bookmark_bar_get_type (void);
GtkWidget *kz_bookmark_bar_new      (KzWindow *kz);

G_END_DECLS

#endif /* __KZ_BOOKMARK_BAR_H__ */
