/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __PREFS_H__
#define __PREFS_H__

#include <glib.h>

G_BEGIN_DECLS

/* define enumeration values to be returned for specific symbols */
typedef enum {
   KZRC_TOKEN_FIRST = G_TOKEN_LAST,
   KZRC_TOKEN_WIDTH,
   KZRC_TOKEN_HEIGHT,
   KZRC_TOKEN_PROXY,
   KZRC_TOKEN_MAILER,
   KZRC_TOKEN_USERAGENT,
   KZRC_TOKEN_TYPEAHEAD,

   KZRC_TOKEN_LAST
} kzprefs_TokenType;

typedef struct _KazehakasePrefs {
	gchar *proxy;
	gint width;
	gint height;
	gchar *mailer;
	gchar *user_agent;
	gboolean typeahead;
} KazehakasePrefs;

KazehakasePrefs prefs;

void prefs_init(void);
void prefs_free(void);

G_END_DECLS

#endif /* __PREFS_H__ */
