/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __RSS_MENU_H__
#define __RSS_MENU_H__

#include <gtk/gtk.h>

#include "kz-window.h"
#include "kz-rss.h"

G_BEGIN_DECLS

#define RSS_TYPE_MENU		 (rss_menu_get_type ())
#define RSS_MENU(obj)		 (G_TYPE_CHECK_INSTANCE_CAST ((obj), RSS_TYPE_MENU, RSSMenu))
#define RSS_MENU_CLASS(klass)	 (G_TYPE_CHECK_CLASS_CAST ((klass),  RSS_TYPE_MENU, RSSMenuClass))
#define RSS_IS_MENU(obj)	 (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RSS_TYPE_MENU))
#define RSS_IS_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  RSS_TYPE_MENU))
#define RSS_MENU_GET_CLASS(obj)	 (G_TYPE_INSTANCE_GET_CLASS ((obj),  RSS_TYPE_MENU, RSSMenuClass))

typedef struct _RSSMenu           RSSMenu;
typedef struct _RSSMenuClass      RSSMenuClass;

struct _RSSMenu
{
	GtkHBox parent;

	/* Parent Kazehakase */
	KzWindow *kz;

	/* widget */
	GtkWidget *MenuItem;
	GtkWidget *SubMenu;
	GtkWidget *update_button;

	KzRSS *rss;
};

struct _RSSMenuClass
{
	GtkHBoxClass parent_class;
};

GtkType    rss_menu_get_type(void);
GtkWidget *rss_menu_new(KzWindow *kz, KzRSS *rss);

G_END_DECLS

#endif /* __RSS_MENU_H__ */
