/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GOOGLE_H__
#define __GOOGLE_H__

/*
 *  This widget is temporary solution to create a google item.
 *  We'll replace this with KzBookmark and KzBookmarkAction.
 *  (Smart bookmark)
 */

#include <gtk/gtk.h>
#include "kz-window.h"
#include "kz-bookmark.h"

G_BEGIN_DECLS

typedef struct _Google Google;

struct _Google
{
	KzWindow *kz;
	/* widget */
	GtkWidget *entry;
	GtkWidget *icon;
	GtkWidget *history_menu;
	
	/* google uri */
	gchar *uri;
	
	/* google history */
	KzBookmark *history;

	/* keyword history */
	GList *keyword;
};

GtkWidget *google_new (KzWindow *kz);
Google    *google_get (GtkWidget *widget);

G_END_DECLS

#endif /* __GOOGLE_H__ */
