/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-bookmark-menu.h 468 2003-11-16 14:44:26Z makeinu $
 */

#ifndef __KZ_BOOKMARK_MENU_H__
#define __KZ_BOOKMARK_MENU_H__

#include <gtk/gtk.h>

#include "kz-window.h"
#include "kz-bookmark.h"

G_BEGIN_DECLS

GtkWidget *kz_bookmark_menu_create_menuitem  (KzBookmark *bookmark,
					      KzWindow   *kz,
					      gboolean    is_folder_proxy);
GtkWidget *kz_bookmark_menu_create_submenu   (KzBookmark *folder,
					      KzWindow   *kz);

void       kz_boommark_menu_append_menuitems (GtkMenuShell *shell,
					      KzWindow     *kz,
					      KzBookmark   *folder);
void       kz_boommark_menu_remove_menuitems (GtkMenuShell *shell,
					      KzWindow     *kz);

G_END_DECLS

#endif /* __KZ_BOOKMARK_MENU_H__ */
