/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Junichiro Kita
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_PROXY_ITEM_H__
#define __KZ_PROXY_ITEM_H__

#include <glib-object.h>
#include <glib.h>

G_BEGIN_DECLS

#define KZ_TYPE_PROXY_ITEM		(kz_proxy_item_get_type ())
#define KZ_PROXY_ITEM(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_PROXY_ITEM, KzProxyItem))
#define KZ_PROXY_ITEM_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_PROXY_ITEM, KzProxyItemClass))
#define KZ_IS_PROXY_ITEM(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_PROXY_ITEM))
#define KZ_IS_PROXY_ITEM_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_PROXY_ITEM))
#define KZ_PROXY_ITEM_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_PROXY_ITEM, KzProxyItemClass))

typedef struct _KzProxyItem KzProxyItem;
typedef struct _KzProxyItemClass KzProxyItemClass;

struct _KzProxyItem
{
	GObject parent;

	gchar    *name;
	gboolean  use_proxy;
	gboolean  use_same_proxy;
	gchar    *http_host;
	guint     http_port;
	gchar    *https_host;
	guint     https_port;
	gchar    *ftp_host;
	guint     ftp_port;
	gchar    *no_proxies_on;
};

struct _KzProxyItemClass
{
	GObjectClass parent_class;
};

GType        kz_proxy_item_get_type (void);
KzProxyItem *kz_proxy_item_new      (void);
KzProxyItem *kz_proxy_find          (const char *proxy_name);
GList       *kz_proxy_get_list      (void);
void         kz_proxy_set_list      (GList *proxy_list);

G_END_DECLS

#endif /* __KZ_PROXY_ITEM_H__ */
