/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef KZ_HISTORY_SEARCH_ACTION_H
#define KZ_HISTORY_SEARCH_ACTION_H

#include <gtk/gtk.h>

#include "egg-entry-action.h"
#include "kz-window.h"

#define KZ_TYPE_HISTORY_SEARCH_ACTION            (kz_history_search_action_get_type())
#define KZ_HISTORY_SEARCH_ACTION(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), KZ_TYPE_HISTORY_SEARCH_ACTION, KzHistorySearchAction))
#define KZ_HISTORY_SEARCH_ACTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), KZ_TYPE_HISTORY_SEARCH_ACTION, KzHistorySearchActionClass))
#define KZ_IS_HISTORY_SEARCH_ACTION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), KZ_TYPE_HISTORY_SEARCH_ACTION))
#define KZ_IS_HISTORY_SEARCH_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((obj), KZ_TYPE_HISTORY_SEARCH_ACTION))
#define KZ_HISTORY_SEARCH_ACTION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), KZ_TYPE_HISTORY_SEARCH_ACTION, KzHistorySearchActionClass))

typedef struct _KzHistorySearchAction      KzHistorySearchAction;
typedef struct _KzHistorySearchActionClass KzHistorySearchActionClass;

struct _KzHistorySearchAction
{
	EggEntryAction  parent;
	KzWindow         *kz;
};

struct _KzHistorySearchActionClass
{
	EggEntryActionClass parent_class;
};

GType	 kz_history_search_action_get_type        (void);
KzHistorySearchAction 
	*kz_history_search_action_new             (KzWindow *kz);

#endif /* KZ_HISTORY_SEARCH_ACTION_H */
