/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_ENTRY_H__
#define __KZ_ENTRY_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define KZ_TYPE_ENTRY		(kz_entry_get_type ())
#define KZ_ENTRY(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_ENTRY, KzEntry))
#define KZ_ENTRY_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_ENTRY, KzEntryClass))
#define KZ_IS_ENTRY(obj)	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_ENTRY))
#define KZ_IS_ENTRY_CLASS(klass)(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_ENTRY))
#define KZ_ENTRY_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_ENTRY, KzEntryClass))

typedef struct _KzEntry           KzEntry;
typedef struct _KzEntryClass      KzEntryClass;

typedef enum
{
	KZ_ENTRY_ICON_EMPTY,
	KZ_ENTRY_ICON_PIXBUF,
	KZ_ENTRY_ICON_STOCK
} KzEntryIconType;


struct _KzEntry
{
	GtkEntry parent;
	gchar *backtext;
	
	KzEntryIconType icon_type;
  
	GdkWindow *icon_area;
	GdkPixbuf *pixbuf;

	gchar *stock_id;
	GtkIconSize icon_size;
	
	gint icon_width;
	gint icon_height;

	gboolean from_outside;
};

struct _KzEntryClass
{
	GtkEntryClass parent_class;
	/* signals */
	void (*icon_pressed)   (KzEntry *entry, GdkEventButton *event);
};

GtkType    kz_entry_get_type      (void);
GtkWidget *kz_entry_new           (void);
GtkWidget *kz_entry_new_with_icon (const gchar *stock_id);

void       kz_entry_set_backtext            (KzEntry      *entry,
					     const gchar  *text);
void       kz_entry_set_icon_from_stock     (KzEntry      *entry,
					     const gchar  *stock_id,
					     GtkIconSize   size);
void       kz_entry_set_icon_from_pixbuf    (KzEntry      *entry,
					     GdkPixbuf    *icon);
G_CONST_RETURN gchar* kz_entry_get_backtext (KzEntry      *entry);

G_END_DECLS

#endif /* __KZ_ENTRY_H__ */
