/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MIGEMO_H__
#define __MIGEMO_H__


#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif /* HAVE_CONFIG_H */

#if USE_MIGEMO

# include <glib.h>

#include "glib-utils.h"

G_BEGIN_DECLS

typedef struct _Migemo Migemo;

struct _Migemo
{
	GPid pid;
	
	gint input;
	gint output;
	gint error;
};
	
gboolean migemo_init                 (void);
void     migemo_exit                 (void);
gchar *  migemo_get_word             (const gchar *body,
				      const gchar *text);

G_END_DECLS

#endif /* USE_MIGEMO */
#endif /* __MIGEMO_H__ */
