/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef KZ_LOCATION_ENTRY_ACTION_H
#define KZ_LOCATION_ENTRY_ACTION_H

#include <gtk/gtk.h>

#include "kz-history-action.h"
#include "kz-window.h"
#include "kz-bookmark.h"

#define KZ_TYPE_LOCATION_ENTRY_ACTION            (kz_location_entry_action_get_type())
#define KZ_LOCATION_ENTRY_ACTION(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), KZ_TYPE_LOCATION_ENTRY_ACTION, KzLocationEntryAction))
#define KZ_LOCATION_ENTRY_ACTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), KZ_TYPE_LOCATION_ENTRY_ACTION, KzLocationEntryActionClass))
#define KZ_IS_LOCATION_ENTRY_ACTION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), KZ_TYPE_LOCATION_ENTRY_ACTION))
#define KZ_IS_LOCATION_ENTRY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((obj), KZ_TYPE_LOCATION_ENTRY_ACTION))
#define KZ_LOCATION_ENTRY_ACTION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), KZ_TYPE_LOCATION_ENTRY_ACTION, KzLocationEntryActionClass))

typedef struct _KzLocationEntryAction      KzLocationEntryAction;
typedef struct _KzLocationEntryActionClass KzLocationEntryActionClass;

struct _KzLocationEntryAction
{
	KzHistoryAction   parent;
	KzWindow         *kz;
	KzBookmark       *bookmark;
	gboolean          activating;
	gboolean          synchronizing;
};

struct _KzLocationEntryActionClass
{
	KzHistoryActionClass parent_class;
};

GType	 kz_location_entry_action_get_type        (void);
KzLocationEntryAction 
	*kz_location_entry_action_new             (KzWindow *kz,
						   KzBookmark *bookmark);
void     kz_location_entry_action_store_history   (KzLocationEntryAction *action);
void     kz_location_entry_action_restore_history (KzLocationEntryAction *action);

#endif /* KZ_LOCATION_ENTRY_ACTION_H */
