/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-bookmark-item.h 1588 2004-09-30 04:32:11Z makeinu $
 */

#ifndef __KZ_BOOKMARK_ITEM_H__
#define __KZ_BOOKMARK_ITEM_H__

#include <gtk/gtk.h>

#include "kz-window.h"
#include "kz-bookmark.h"

G_BEGIN_DECLS

#define KZ_TYPE_BOOKMARK_ITEM		(kz_bookmark_item_get_type ())
#define KZ_BOOKMARK_ITEM(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BOOKMARK_ITEM, KzBookmarkItem))
#define KZ_BOOKMARK_ITEM_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_Bookmark_ITEM, KzBookmarkItemClass))
#define KZ_IS_BOOKMARK_ITEM(obj)	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BOOKMARK_ITEM))
#define KZ_IS_BOOKMARK_ITEM_CLASS(klass)(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_BOOKMARK_ITEM))
#define KZ_BOOKMARK_ITEM_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_Bookmark_ITEM, KzBookmarkItemClass))

typedef struct _KzBookmarkItem           KzBookmarkItem;
typedef struct _KzBookmarkItemClass      KzBookmarkItemClass;

struct _KzBookmarkItem
{
	GtkHBox parent;

	/* Parent Kazehakase */
	KzWindow *kz;

	/* widget */
	GtkWidget *update_button;
	GtkWidget *image;
	GtkWidget *eventbox;
	GtkWidget *label;
	GtkWidget *sub_menu;

	KzBookmark *bookmark;
};

struct _KzBookmarkItemClass
{
	GtkHBoxClass parent_class;
};

GtkType    kz_bookmark_item_get_type (void);
GtkWidget *kz_bookmark_item_new      (KzWindow *kz, KzBookmark *bookmark);

G_END_DECLS

#endif /* __KZ_BOOKMARK_ITEM_H__ */
