/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_DOWNLOADER_GRP_H__
#define __KZ_DOWNLOADER_GRP_H__

#include "kz-downloader.h"

G_BEGIN_DECLS

#define KZ_TYPE_DOWNLOADER_GROUP		(kz_downloader_group_get_type ())
#define KZ_DOWNLOADER_GROUP(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_DOWNLOADER_GROUP, KzDownloaderGroup))
#define KZ_DOWNLOADER_GROUP_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_DOWNLOADER_GROUP, KzDownloaderGroupClass))
#define KZ_IS_DOWNLOADER_GROUP(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_DOWNLOADER_GROUP))
#define KZ_IS_DOWNLOADER_GROUP_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_DOWNLOADER_GROUP))
#define KZ_DOWNLOADER_GROUP_GET_CLASS(obj)	(G_TYPE_INSTANCE_CHECK_GET_CLASS ((obj), KZ_TYPE_DOWNLOADER_GROUP, KzDownloaderGroupClass))

typedef struct _KzDownloaderGroup      KzDownloaderGroup;
typedef struct _KzDownloaderGroupClass KzDownloaderGroupClass;

struct _KzDownloaderGroup
{
	GObject parent;
	/* downloader item list */
	GSList *items;
};

struct _KzDownloaderGroupClass
{
	GObjectClass parent_class;

	/* -- signals -- */
	void (*add)      (KzDownloaderGroup *dlgrp,
			  KzDownloader      *dl);
	void (*remove)   (KzDownloaderGroup *dlgrp,
			  KzDownloader      *dl);
	void (*error)    (KzDownloaderGroup *dlgrp,
			  KzDownloader      *dl);
	void (*progress) (KzDownloaderGroup *dlgrp,
			  KzDownloader      *dl);
};

GType              kz_downloader_group_get_type (void);
KzDownloaderGroup *kz_downloader_group_new      (void);

void  kz_downloader_group_dispose (GObject *object);

/* singleton */
KzDownloaderGroup *kz_downloader_group_get_instance (void);

void  kz_downloader_group_add_item    (KzDownloaderGroup *dlgrp,
				       const gchar *uri);

void  kz_downloader_group_add_item_with_filename    (KzDownloaderGroup *dlgrp,
				       		     const gchar *uri,
						     const gchar *filename);

void  kz_downloader_group_remove_item (KzDownloaderGroup *dlgrp, KzDownloader *dl);

void kz_downloader_group_add_downloader (KzDownloaderGroup *dlgrp,
					 KzDownloader      *dl);

G_END_DECLS

#endif /* __KZ_DOWNLOADER_GROUP_H__ */
