/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002  Ricardo Fern-Andez Pascual$)B
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *  2003/02/15: arranged by Takuro Ashie <ashie@homa.ne.jp>
 */

#ifndef __GOBJECT_UTILS_H__
#define __GOBJECT_UTILS_H__

#define KZ_OBJECT_GET_TYPE(l,str,t,ci,i,parent) \
GType l##_get_type(void)\
{\
	static GType type = 0;				\
	if (!type) {					\
		static GTypeInfo const object_info = {	\
			sizeof (t##Class),		\
							\
			(GBaseInitFunc) NULL,		\
			(GBaseFinalizeFunc) NULL,	\
							\
			(GClassInitFunc) ci,		\
			(GClassFinalizeFunc) NULL,	\
			NULL,	/* class_data */	\
							\
			sizeof (t),			\
			0,	/* n_preallocs */	\
			(GInstanceInitFunc) i,		\
		};					\
		type = g_type_register_static (parent, str, &object_info, (GTypeFlags)0);	\
	}						\
	return type;					\
}

#define KZ_OBJECT_GET_TYPE_IFACE(l,str,t,ci,i,parent,ii,iparent) \
GType l##_get_type(void)\
{\
	static GType type = 0;				\
	if (!type) {					\
		static GTypeInfo const object_info = {	\
			sizeof (t##Class),		\
							\
			(GBaseInitFunc) NULL,		\
			(GBaseFinalizeFunc) NULL,	\
							\
			(GClassInitFunc) ci,		\
			(GClassFinalizeFunc) NULL,	\
			NULL,	/* class_data */	\
							\
			sizeof (t),			\
			0,	/* n_preallocs */	\
			(GInstanceInitFunc) i,		\
		};					\
							\
		static const GInterfaceInfo iface_info = {	\
			(GInterfaceInitFunc) ii,	\
			NULL,				\
			NULL				\
		};					\
							\
		type = g_type_register_static (parent, str, &object_info, (GTypeFlags)0);	\
							\
		g_type_add_interface_static (type,	\
					     iparent,	\
					     &iface_info);	\
	}						\
	return type;					\
}

#define KZ_OBJECT_FINALIZE(n,N)						\
									\
static void								\
n##_finalize (GObject *object)						\
{									\
	N *o = (N *) object;						\
									\
	g_free (o->priv);						\
									\
	if (G_OBJECT_CLASS (parent_class)->finalize)			\
		G_OBJECT_CLASS (parent_class)->finalize (object);	\
}

#endif /* __GOBJECT_UTILS_H__ */
