Gtk.init

module Kz
  DEFAULT_LOAD_PATH = $LOAD_PATH.dup

  class << self
    def barrier
      yield
    rescue Exception
      print_error($!)
    end

    def reload(kz)
      barrier do
        if ENABLE
          $LOAD_PATH.clear
          $LOAD_PATH.concat(DEFAULT_LOAD_PATH)
          kz.ext_reload
        end
      end
    end

    def pop_statusbar(kz, id, timeout)
      Gtk.timeout_add(timeout) do
        kz.statusbar.pop(id)
        false
      end
    end

    def setup(kz)
      barrier do
        kz.ext_setup
      end
    end
  end

  class Window
    def ext_setup
      Actions.init_actions(self)
    end

    def ext_reload
      Actions.reload_actions(self)
    end
  end
end

require "kz/utils"
require "kz/actions"
