Gtk.init

module Kz
  DEFAULT_LOAD_PATH = $LOAD_PATH.dup

  class << self
    def reload(kz)
      barrier do
        if ENABLE
          $LOAD_PATH.clear
          $LOAD_PATH.concat(DEFAULT_LOAD_PATH)
          kz.ext_reload
        end
      end
    end

    def pop_statusbar(kz, id_or_name, timeout)
      Gtk.timeout_add(timeout) do
        barrier do
          kz.statusbar.set_text(nil, id_or_name)
          false
        end
      end
    end

    def setup(kz)
      barrier do
        kz.ext_setup
      end
    end
  end

  class Window
    def ext_setup
      Actions.init_actions(self)
    end

    def ext_reload
      Actions.reload_actions(self)
    end
  end
end

require "kz/utils"
require "kz/actions"
