/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002-2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MOZILLA_PREFS_H__
#define __MOZILLA_PREFS_H__

#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif

#include <glib.h>
#include "kz-proxy-item.h"
#include "kz-profile.h"

G_BEGIN_DECLS

gboolean mozilla_prefs_init            (void);
void     mozilla_prefs_set             (KzProfile *profile);
gboolean mozilla_prefs_get_string      (const char  *preference_name,
					char       **value);
gboolean mozilla_prefs_get_int         (const char  *preference_name,
					int         *value);
gboolean mozilla_prefs_get_boolean     (const char  *preference_name,
					gboolean    *value);
gboolean mozilla_prefs_set_string      (const char  *preference_name,
					const char  *new_value);
gboolean mozilla_prefs_set_boolean     (const char  *preference_name,
					gboolean     new_boolean_value);
gboolean mozilla_prefs_set_int         (const char  *preference_name,
					int          new_int_value);

gboolean mozilla_prefs_get_font_list   (const char  *lang_group,
					const char  *font_type,
					GList      **font_list,
					GList      **all_font_list,
					char       **default_font);

void     mozilla_prefs_set_proxy       (KzProxyItem *item);
void     mozilla_prefs_set_use_proxy   (gboolean use);

G_END_DECLS

#endif /* __MOZILLA_PREFS_H__ */
