/* GNet - Networking library
 * Copyright (C) 2000-2001  David Helder, David Bolcsfoldi
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */


#ifndef _GNET_URI_H
#define _GNET_URI_H

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/**
 *  KzURI:
 *  @scheme: Scheme (or protocol)
 *  @userinfo: User info
 *  @hostname: Host name
 *  @port: Port number
 *  @path: Path
 *  @query: Query
 *  @fragment: Fragment
 *
 *  The #KzURI structure represents a URI.  All fields in this
 *  structure are publicly readable.
 *
 **/
typedef struct _KzURI KzURI;

struct _KzURI
{
  gchar* scheme;
  gchar* userinfo;
  gchar* hostname;
  gint   port;
  gchar* path;
  gchar* query;
  gchar* fragment;
};



KzURI*     kz_uri_new (const gchar* uri);
KzURI*     kz_uri_new_fields (const gchar* scheme, const gchar* hostname, 
			       const gint port, const gchar* path);
KzURI*	  kz_uri_new_fields_all (const gchar* scheme, const gchar* userinfo, 
				   const gchar* hostname, const gint port, 
				   const gchar* path, 
				   const gchar* query, const gchar* fragment);
KzURI*     kz_uri_clone (const KzURI* uri);
void      kz_uri_delete (KzURI* uri);
	       
gboolean  kz_uri_equal (gconstpointer p1, gconstpointer p2);
guint     kz_uri_hash (gconstpointer p);

void	  kz_uri_escape (KzURI* uri);
void	  kz_uri_unescape (KzURI* uri);

gchar* 	  kz_uri_get_string (const KzURI* uri);

void 	  kz_uri_set_scheme   (KzURI* uri, const gchar* scheme);
void 	  kz_uri_set_userinfo	(KzURI* uri, const gchar* userinfo);
void 	  kz_uri_set_hostname (KzURI* uri, const gchar* hostname);
void 	  kz_uri_set_port     (KzURI* uri, gint port);
void 	  kz_uri_set_path	(KzURI* uri, const gchar* path);
void 	  kz_uri_set_query 	(KzURI* uri, const gchar* query);
void 	  kz_uri_set_fragment (KzURI* uri, const gchar* fragment);

#ifdef __cplusplus
}
#endif				/* __cplusplus */

#endif /* _GNET_URI_H */
