/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_RSS_MENU_H__
#define __KZ_RSS_MENU_H__

#include <gtk/gtk.h>

#include "kz-window.h"
#include "kz-rss.h"

G_BEGIN_DECLS

#define KZ_TYPE_RSS_MENU	    (kz_rss_menu_get_type ())
#define KZ_RSS_MENU(obj)	    (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_RSS_MENU, KzRSSMenu))
#define KZ_RSS_MENU_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_RSS_MENU, KzRSSMenuClass))
#define KZ_IS_RSS_MENU(obj)	    (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_RSS_MENU))
#define KZ_IS_RSS_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_RSS_MENU))
#define KZ_RSS_MENU_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_RSS_MENU, KzRSSMenuClass))

typedef struct _KzRSSMenu           KzRSSMenu;
typedef struct _KzRSSMenuClass      KzRSSMenuClass;

struct _KzRSSMenu
{
	GtkHBox parent;

	/* Parent Kazehakase */
	KzWindow *kz;

	/* widget */
	GtkWidget *menu_item;
	GtkWidget *sub_menu;
	GtkWidget *update_button;
	GtkWidget *image;

	KzRSS *rss;
};

struct _KzRSSMenuClass
{
	GtkHBoxClass parent_class;
};

GtkType    kz_rss_menu_get_type (void);
GtkWidget *kz_rss_menu_new      (KzWindow *kz, KzRSS *rss);

G_END_DECLS

#endif /* __KZ_RSS_MENU_H__ */
