
/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-sidebar.h"

#include <gtk/gtktreeview.h>
#include <gtk/gtktreestore.h>

#include "kz-rsslist.h"

#ifndef __KZ_RSS_TREE_H__
#define __KZ_RSS_TREE_H__

#define KZ_TYPE_RSS_TREE		(kz_rss_tree_get_type ())
#define KZ_RSS_TREE(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_RSS_TREE, KzRSSTree))
#define KZ_RSS_TREE_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_RSS_TREE, KzRSSTreeClass))
#define KZ_IS_RSS_TREE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_RSS_TREE))
#define KZ_IS_RSS_TREE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_RSS_TREE))
#define KZ_RSS_TREE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_RSS_TREE, KzRSSTreeClass))

typedef struct _KzRSSTree	KzRSSTree;
typedef struct _KzRSSTreeClass	KzRSSTreeClass;
typedef struct _KzRSSTreePriv	KzRSSTreePriv;
typedef struct _KzRSSTreeItem	KzRSSTreeItem;

struct _KzRSSTree
{
	GtkVBox parent;

	KzSidebar    *sidebar;

	GtkTreeView  *tree_view;
	GtkTreeStore *store;

	KzRSSList    *rsslist;
};

struct _KzRSSTreeClass
{
	GtkVBoxClass parent_class;
};

KzSidebarEntry   *kz_rss_tree_get_entry(gint idx);

GtkType	          kz_rss_tree_get_type           (void);
GtkWidget        *kz_rss_tree_new                (KzSidebar *sidebar);

#endif /* __KZ_RSS_TREEH__ */
