/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#define CONTEXT_NONE     0
#define CONTEXT_DEFAULT  1
#define CONTEXT_LINK     2
#define CONTEXT_IMAGE    4
#define CONTEXT_DOCUMENT 8
#define CONTEXT_INPUT    64
#define CONTEXT_OTHER    128
#define CONTEXT_XUL      256

Kazehakase *kazehakase_window_new(gchar *url);
void set_browser_visibility (Kazehakase *kz, gboolean visibility);

KazehakaseEmbed *kazehakase_tab_new(Kazehakase *kz, gchar *url);
void update_nav_buttons (Kazehakase *kz, GtkMozEmbed *embed);
void kazehakase_tab_close (KazehakaseEmbed *kzembed);
void kazehakase_tab_close_cb (GtkWidget *button, KazehakaseEmbed *kzembed);

//glong mozilla_get_context_menu_type(GtkMozEmbed *b, gpointer event, gchar **img, gchar **link, gchar **linktext);
gchar *mozilla_get_title (GtkMozEmbed *embed);
gchar *mozilla_get_link_message (GtkMozEmbed *embed);

/* mozille embed callbacks */
gint dom_mouse_click_cb   (GtkMozEmbed *embed, gpointer event, 
			   KazehakaseEmbed *kzembed);
gint dom_mouse_down_cb    (GtkMozEmbed *embed, gpointer event,
			   KazehakaseEmbed *kzembed);
gint dom_mouse_up_cb      (GtkMozEmbed *embed, gpointer event,
			   KazehakaseEmbed *kzembed);
gint dom_mouse_dbl_click_cb (GtkMozEmbed *embed, gpointer event,
			     KazehakaseEmbed *kzembed);
gint dom_mouse_over_cb    (GtkMozEmbed *embed, gpointer event,
			   KazehakaseEmbed *kzembed);
gint dom_mouse_out_cb     (GtkMozEmbed *embed, gpointer event,
			   KazehakaseEmbed *kzembed);

gint dom_key_press_cb     (GtkMozEmbed *embed, gpointer event,
			   KazehakaseEmbed *kzembed);
gint dom_key_down_cb      (GtkMozEmbed *embed, gpointer event,
			   KazehakaseEmbed *kzembed);
gint dom_key_up_cb        (GtkMozEmbed *embed, gpointer event,
			   KazehakaseEmbed *kzembed);
gint dom_key_press_cb     (GtkMozEmbed *embed, gpointer event,
			   KazehakaseEmbed *kzembed);

void load_started_cb      (GtkMozEmbed *embed, KazehakaseEmbed *kzembed);
void load_finished_cb     (GtkMozEmbed *embed, KazehakaseEmbed *kzembed);

void title_changed_cb     (GtkMozEmbed *embed, KazehakaseEmbed *kzembed);
void location_changed_cb  (GtkMozEmbed *embed, KazehakaseEmbed *kzembed);
void link_message_cb      (GtkMozEmbed *embed, KazehakaseEmbed *kzembed);
void new_window_cb        (GtkMozEmbed *embed, GtkMozEmbed **retval, 
			   guint chromemask, KazehakaseEmbed *kzembed);
void destroy_browser_cb   (GtkMozEmbed *embed, GtkWidget *transient_window);
//void destroy_brsr_cb   (GtkMozEmbed *embed, KazehakaseEmbed *kzembed);
//void destroy_cb   (GtkMozEmbed *embed, KazehakaseEmbed *kzembed);
void visibility_cb        (GtkMozEmbed *embed, gboolean visibility,
			   KazehakaseEmbed *kzembed);

void new_window_orphan_cb (GtkMozEmbedSingle *embed, GtkMozEmbed **retval,
			   guint chromemask, gpointer data);

gint open_uri_cb (GtkMozEmbed *embed, const char *uri, KazehakaseEmbed *kzembed);
void size_to_cb (GtkMozEmbed *embed, gint width, gint height,KazehakaseEmbed *kzembed);

void find_keyword_cb (GtkWidget *widget, Kazehakase *kz);
