/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <gtk/gtk.h>

#include "gtkmozembed.h"

#include "kazehakase-type.h"
#include "kazehakase.h"
#include "prefs.h"

int main(int argc, char *argv[])
{
	gchar *url = NULL;
	gtk_set_locale();
	gtk_init(&argc, &argv);

	char *home_path;
	char *full_path;
     	home_path = (gchar*)g_get_home_dir();
	if (!home_path) {
		fprintf(stderr, "Failed to get HOME\n");
		exit(1);
	}
  
	full_path = g_strdup_printf("%s/%s", home_path, ".kazehakase/mozilla");
	
	gtk_moz_embed_set_profile_path(full_path, "kazehakase");
	
	prefs_init();

	gtk_moz_embed_push_startup();

	if (argc > 1)
	  url = argv[1];
	else
	  url = prefs.home_uri;
	
	Kazehakase *kz = 0;
	kz = kazehakase_window_new(url);

	set_browser_visibility(kz, TRUE);

	// get the singleton object and hook up to its new window callback
	// so we can create orphaned windows.

	GtkMozEmbedSingle *single;

	single = gtk_moz_embed_single_get();
	if (!single) {
		fprintf(stderr, "Failed to get singleton embed object!\n");
		exit(1);
	}

	g_signal_connect(G_OBJECT(single), "new_window_orphan",
			   G_CALLBACK(new_window_orphan_cb), NULL);

	gtk_main();
}
