/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#define CONTEXT_NONE     0
#define CONTEXT_DEFAULT  1
#define CONTEXT_LINK     2
#define CONTEXT_IMAGE    4
#define CONTEXT_DOCUMENT 8
#define CONTEXT_INPUT    64
#define CONTEXT_OTHER    128
#define CONTEXT_XUL      256

typedef struct
{
	gchar *img;
	gchar *link;
	gchar *linktext;
	
	gboolean framed_page;
	
	gint context;
} ContextInfo;

typedef struct
{
	ContextInfo cinfo;
	int key;
	gint modifier;
} KeyEventInfo;

typedef struct
{
	ContextInfo cinfo;
	gint button;
	gint modifier;
	guint timestamp;
} MouseEventInfo;
