/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <ctype.h>
#include <glib/gi18n.h>
#include <glib.h>
#include <glib/gstdio.h>

#include "kazehakase.h"
#include "utils/utils.h"
#include "glib-utils.h"
#include "kz-search-common.h"
#include "kz-search-rast.h"
#include "egg-pixbuf-thumbnail.h"
#include <rast/rast.h>


#define HISTORY_INDEX "history_index.rast"

typedef struct _KzSearchRastPrivate	KzSearchRastPrivate;
struct _KzSearchRastPrivate
{
};

typedef struct _KzSearchRastClass	KzSearchRastClass;
struct _KzSearchRastClass
{
	KzSearchClass parent_class;
};

#define KZ_SEARCH_RAST_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), KZ_TYPE_SEARCH_RAST, KzSearchRastPrivate))

#define KZ_SEARCH_RAST_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_SEARCH_RAST, KzSearchRastClass))
#define KZ_IS_SEARCH_RAST_CLASS(klass) 	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_SEARCH_RAST))
#define KZ_SEARCH_RAST_GET_CLASS(obj)  	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_SEARCH_RAST, KzSearchRastClass))

/* for module */
void        kz_search_module_init		(GTypeModule *module);
void        kz_search_module_exit		(void);
KzSearch   *kz_search_module_create		(void);

/* KzSearchRast Class */
static void   kz_search_rast_class_init (KzSearchRastClass *klass);
static void   kz_search_rast_init       (KzSearchRast *search);

/* GObject Class */
static GObject *constructor  (GType type,
                              guint n_props,
                              GObjectConstructParam *props);
static void     dispose      (GObject *object);

/* KzSearch Class */
static gchar	  *get_search_result_html     (KzSearch *search, const gchar *text);
static KzBookmark *get_search_result_bookmark (KzSearch *search, const gchar *text);
static gboolean    register_document          (KzSearch *search,
					       const gchar *uri,
					       const gchar *title,
					       const gchar *contents,
					       GTime mtime);
static gboolean    unregister_document        (KzSearch *search, const gchar *uri);
static GPid        optimize_index             (KzSearch *search);
static void        make_index                 (KzSearch *search);
static gboolean    exist_index_dir            (KzSearch *search);

static KzSearchRast *the_kz_search_rast = NULL;

static GObjectClass *parent_class;
static GType kz_search_rast_type = 0;

static void
kz_search_rast_register_type (GTypeModule *module)
{
	static const GTypeInfo kz_search_rast_info =
	{
		sizeof (KzSearchRastClass),
		NULL,		/* base_init */
		NULL,		/* base_finalize */
		(GClassInitFunc) kz_search_rast_class_init,
		NULL,		/* class_finalize */
		NULL,		/* class_data */
		sizeof (KzSearchRast),
		0,		/* n_preallocs */
		(GInstanceInitFunc) kz_search_rast_init,
	};

	kz_search_rast_type = g_type_module_register_type (module,
			KZ_TYPE_SEARCH,
			"KzSearchRast",
			&kz_search_rast_info, 0);
}

G_MODULE_EXPORT void 
kz_search_module_init (GTypeModule *module)
{
	kz_search_rast_register_type(module);
}

G_MODULE_EXPORT void 
kz_search_module_exit (void)
{
}

G_MODULE_EXPORT KzSearch * 
kz_search_module_create (void)
{
	return kz_search_rast_new();
}

GType
kz_search_rast_get_type (void)
{
	return kz_search_rast_type;
}

static void
kz_search_rast_class_init (KzSearchRastClass *klass)
{
	GObjectClass *object_class;
	KzSearchClass *search_class;

	parent_class = g_type_class_peek_parent (klass);
	object_class = G_OBJECT_CLASS(klass);
	search_class = KZ_SEARCH_CLASS(klass);

	object_class->constructor = constructor;
	object_class->dispose     = dispose;
	
	search_class->get_search_result_html     = get_search_result_html;
	search_class->get_search_result_bookmark = get_search_result_bookmark;
	search_class->register_document          = register_document;
	search_class->unregister_document        = unregister_document;
	search_class->optimize_index             = optimize_index;
	search_class->make_index                 = make_index;
	search_class->exist_index_dir            = exist_index_dir;

	g_type_class_add_private (object_class, sizeof(KzSearchRastPrivate));
}


static void
kz_search_rast_init (KzSearchRast *search)
{
	rast_error_t *error;

	apr_initialize();

	error = rast_initialize();
}

static GObject *
constructor (GType                  type,
             guint                  n_props,
             GObjectConstructParam *props)
{
	GObject *object;

	if (!the_kz_search_rast) 
	{
		GObjectClass *klass = G_OBJECT_CLASS(parent_class);
		object = klass->constructor(type, n_props, props);
		the_kz_search_rast = KZ_SEARCH_RAST(object);
	}
	else
	{
		object = g_object_ref(G_OBJECT(the_kz_search_rast));
	}
	return object;
}

static void
dispose (GObject *object)
{
	rast_finalize();
	apr_terminate();

	if (G_OBJECT_CLASS(parent_class)->dispose)
		G_OBJECT_CLASS(parent_class)->dispose(object);
}


KzSearch *
kz_search_rast_new (void)
{
	return KZ_SEARCH(g_object_new(KZ_TYPE_SEARCH_RAST, NULL));
}

gchar *
get_search_result_html (KzSearch *search, const gchar *text)
{
	if (!text) return NULL;

	return NULL;
}

gboolean
register_document (KzSearch *search, const gchar *uri, const gchar *title, const gchar *contents, GTime mtime)
{
	return FALSE;
}

gboolean
unregister_document (KzSearch *search, const gchar *uri)
{
	return FALSE;
}

static GPid
optimize_index (KzSearch *search)
{
	return 0;
}

static KzBookmark *
get_search_result_bookmark (KzSearch *search, const gchar *text)
{
	/* not implemented yet */
	return NULL;
}

static void
make_index (KzSearch *search)
{
}

static gboolean
exist_index_dir(KzSearch *search)
{
	gboolean exist = FALSE;

	return exist;
}
