/*
 *  Copyright (C) 2006 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __RD_IMAGE_FACTORY_H__
#define __RD_IMAGE_FACTORY_H__

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS

#define RD_TYPE_IMAGE_FACTORY            (rd_image_factory_get_type ())
#define RD_IMAGE_FACTORY(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), RD_TYPE_IMAGE_FACTORY, RdImageFactory))
#define RD_IMAGE_FACTORY_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), RD_TYPE_IMAGE_FACTORY, RdImageFactoryClass))
#define RD_IS_IMAGE_FACTORY(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RD_TYPE_IMAGE_FACTORY))
#define RD_IS_IMAGE_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RD_TYPE_IMAGE_FACTORY))
#define RD_IMAGE_FACTORY_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), RD_TYPE_IMAGE_FACTORY, RdImageFactoryClass))

typedef struct _RdImageFactory	RdImageFactory;
typedef struct _RdImageFactoryClass	RdImageFactoryClass;

struct _RdImageFactory
{
	GObject parent;
};

struct _RdImageFactoryClass
{
	GObjectClass parent_class;

	/* signals */
	void (*ready)         (RdImageFactory *factory,
			       gpointer image_data,
			       const gchar *uri);
};

GType	            rd_image_factory_get_type  (void);

RdImageFactory *rd_image_factory_new       (void);

void		    rd_image_factory_request_uri (RdImageFactory *factory, const gchar *uri);

G_END_DECLS

#endif /* __RD_IMAGE_FACTORY_H__ */
