#include "GeckoContentHandler.h"

#include "rendako.h"

#include <nsEmbedString.h>
#include <GeckoThumbnailer.h>

#include <glib.h>

NS_IMPL_ISUPPORTS1(GeckoContentHandler, nsISAXContentHandler)

GeckoContentHandler::GeckoContentHandler ()
{
	mState = 0;
	mOwner = NULL;
}

GeckoContentHandler::~GeckoContentHandler ()
{
}

NS_IMETHODIMP
GeckoContentHandler::Init (RdOpenSearch *owner)
{
	mOwner = owner;
}

/* void startDocument (); */
NS_IMETHODIMP
GeckoContentHandler::StartDocument()
{
	return NS_OK;
}

/* void endDocument (); */
NS_IMETHODIMP
GeckoContentHandler::EndDocument()
{
	return NS_OK;
}

/* void startElement (in AString uri, in AString localName, in AString qName, in nsISAXAttributes attributes); */
NS_IMETHODIMP
GeckoContentHandler::StartElement(const nsAString & uri, const nsAString & localName, const nsAString & qName, nsISAXAttributes *attributes)
{
	nsEmbedCString cValue;
	NS_UTF16ToCString (qName, NS_CSTRING_ENCODING_UTF8, cValue);
	if (cValue.Equals (NS_LITERAL_CSTRING("link"))) mState = 1;

	return NS_OK;
}

/* void endElement (in AString uri, in AString localName, in AString qName); */
NS_IMETHODIMP
GeckoContentHandler::EndElement(const nsAString & uri, const nsAString & localName, const nsAString & qName)
{
	nsEmbedCString cValue;
	NS_UTF16ToCString (qName, NS_CSTRING_ENCODING_UTF8, cValue);
	if (cValue.Equals (NS_LITERAL_CSTRING("link"))) mState = 0;

	return NS_OK;
}

/* void characters (in AString value); */
NS_IMETHODIMP
GeckoContentHandler::Characters(const nsAString & value)
{
	nsresult rv;

	nsEmbedCString cValue;
	NS_UTF16ToCString (value, NS_CSTRING_ENCODING_UTF8, cValue);
	switch (mState)
	{
	case 1:
		g_signal_emit_by_name (mOwner, "link", cValue.get());
		break;
	case 2:
		g_signal_emit_by_name (mOwner, "description", cValue.get());
		break;
	default:
		break;
	}

	return NS_OK;
}

/* void processingInstruction (in AString target, in AString data); */
NS_IMETHODIMP
GeckoContentHandler::ProcessingInstruction(const nsAString & target, const nsAString & data)
{
	return NS_OK;
}

/* void ignorableWhitespace (in AString whitespace); */
NS_IMETHODIMP
GeckoContentHandler::IgnorableWhitespace(const nsAString & whitespace)
{
	return NS_OK;
}

/* void startPrefixMapping (in AString prefix, in AString uri); */
NS_IMETHODIMP
GeckoContentHandler::StartPrefixMapping(const nsAString & prefix, const nsAString & uri)
{
	return NS_OK;
}

/* void endPrefixMapping (in AString prefix); */
NS_IMETHODIMP
GeckoContentHandler::EndPrefixMapping(const nsAString & prefix)
{
	return NS_OK;
}
