/*
 *  Copyright (C) 2006 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "rendako.h"
#include "rd-thumbnailer.h"
#include "GeckoThumbnailer.h"
#include "rd-marshalers.h"
#include <glib/gi18n.h>

typedef struct _RdThumbnailerPrivate RdThumbnailerPrivate;
struct _RdThumbnailerPrivate
{
	GeckoThumbnailer *g_thumbnailer;
};

#define RD_THUMBNAILER_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), RD_TYPE_THUMBNAILER, RdThumbnailerPrivate))

enum {
	READY_SIGNAL,
	LAST_SIGNAL
};

static gint rd_thumbnailer_signals[LAST_SIGNAL] = {0};

static void     rd_thumbnailer_class_init     (RdThumbnailerClass *klass);
static void     rd_thumbnailer_init           (RdThumbnailer      *thumbnailer);
static void     rd_thumbnailer_dispose        (GObject            *object);
static void     rd_thumbnailer_finalize       (GObject            *object);

static GObjectClass *parent_class = NULL;

G_DEFINE_TYPE (RdThumbnailer, rd_thumbnailer, G_TYPE_OBJECT)

static void
rd_thumbnailer_class_init (RdThumbnailerClass *klass)
{
	GObjectClass *gobject_class;

	parent_class = (GObjectClass *) g_type_class_peek_parent (klass);

	gobject_class = (GObjectClass *)   klass;
  
	gobject_class->dispose  = rd_thumbnailer_dispose;
	gobject_class->finalize = rd_thumbnailer_finalize;

	klass->ready = NULL;

	rd_thumbnailer_signals[READY_SIGNAL]
		= g_signal_new ("ready",
				G_TYPE_FROM_CLASS (klass),
				(GSignalFlags) (G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED),
				G_STRUCT_OFFSET (RdThumbnailerClass, ready),
				NULL, NULL,
				_rd_marshal_VOID__POINTER_STRING,
				G_TYPE_NONE, 2,
				G_TYPE_POINTER,
				G_TYPE_STRING);

	g_type_class_add_private (gobject_class, sizeof(RdThumbnailerPrivate));
}

static void
rd_thumbnailer_init (RdThumbnailer *thumbnailer)
{
	RdThumbnailerPrivate *priv = RD_THUMBNAILER_GET_PRIVATE (thumbnailer);

	priv->g_thumbnailer = new GeckoThumbnailer;
	priv->g_thumbnailer->Init (thumbnailer);
}

static void
rd_thumbnailer_dispose (GObject *object)
{
	RdThumbnailerPrivate *priv = RD_THUMBNAILER_GET_PRIVATE (object);

	if (priv->g_thumbnailer)
	{
		priv->g_thumbnailer->Destroy ();
		delete priv->g_thumbnailer;
		priv->g_thumbnailer = NULL;
	}

	if (G_OBJECT_CLASS(parent_class)->dispose)	
		G_OBJECT_CLASS (parent_class)->dispose (object);
}

static void
rd_thumbnailer_finalize (GObject *object)
{
	if (G_OBJECT_CLASS(parent_class)->finalize)
		G_OBJECT_CLASS (parent_class)->finalize (object);
}

RdThumbnailer *
rd_thumbnailer_new (void)
{
	RdThumbnailer *thumbnailer;

	thumbnailer = RD_THUMBNAILER (g_object_new (RD_TYPE_THUMBNAILER, NULL));

	return thumbnailer;
}

gboolean
rd_thumbnailer_is_creating (RdThumbnailer *thumbnailer)
{
	RdThumbnailerPrivate *priv = RD_THUMBNAILER_GET_PRIVATE (thumbnailer);

	PRBool ret = priv->g_thumbnailer->IsCreating ();

	return (ret == PR_TRUE) ? TRUE : FALSE;
}

void
rd_thumbnailer_request_uri (RdThumbnailer *thumbnailer, const gchar *uri)
{
	RdThumbnailerPrivate *priv = RD_THUMBNAILER_GET_PRIVATE (thumbnailer);

	priv->g_thumbnailer->AppendQueue (uri);
}

