/**
 ******************************************************************************
 * Copyright (c), Takenori Imoto
 * 楓 software http://www.kaede-software.com/
 * All rights reserved.
 ******************************************************************************
 * ソースコード形式かバイナリ形式か、変更するかしないかを問わず、以下の条件を満
 * たす場合に限り、再頒布および使用が許可されます。
 *
 * ・ソースコードを再頒布する場合、上記の著作権表示、本条件一覧、および下記免責
 *   条項を含めること。
 * ・バイナリ形式で再頒布する場合、頒布物に付属のドキュメント等の資料に、上記の
 *   著作権表示、本条件一覧、および下記免責条項を含めること。
 * ・書面による特別の許可なしに、本ソフトウェアから派生した製品の宣伝または販売
 *   促進に、組織の名前またはコントリビューターの名前を使用してはならない。
 *
 * 本ソフトウェアは、著作権者およびコントリビューターによって「現状のまま」提供
 * されており、明示黙示を問わず、商業的な使用可能性、および特定の目的に対する適
 * 合性に関する暗黙の保証も含め、またそれに限定されない、いかなる保証もありませ
 * ん。著作権者もコントリビューターも、事由のいかんを問わず、損害発生の原因いか
 * んを問わず、かつ責任の根拠が契約であるか厳格責任であるか（過失その他の）不法
 * 行為であるかを問わず、仮にそのような損害が発生する可能性を知らされていたとし
 * ても、本ソフトウェアの使用によって発生した（代替品または代用サービスの調達、
 * 使用の喪失、データの喪失、利益の喪失、業務の中断も含め、またそれに限定されな
 * い）直接損害、間接損害、偶発的な損害、特別損害、懲罰的損害、または結果損害に
 * ついて、一切責任を負わないものとします。
 ******************************************************************************
 * 本ソフトウェアは、吉里吉里2 ( http://kikyou.info/tvp/ ) のソースコードをJava
 * に書き換えたものを一部使用しています。
 * 吉里吉里2 Copyright (C) W.Dee <dee@kikyou.info> and contributors
 ******************************************************************************
 */
package jp.kirikiri.tjs2;

public class ScriptLineData {

	private final String mString;

	private IntVector mLineVector;
	private IntVector mLineLengthVector;
	private int mLineOffset;

	static private final int CARRIAGE_RETURN = 13;
	static private final int LINE_FEED = 10;

	public ScriptLineData( String string, int offset ) {
		mString = string;
		mLineOffset = offset;
	}

	private final void generateLineVector() {
		mLineVector = new IntVector();
		mLineLengthVector = new IntVector();
		int count = mString.length();
		int lastCR = 0;
		int i;
		for( i= 0; i < count; i++ ) {
			int c = mString.charAt(i);
			if( c == CARRIAGE_RETURN || c == LINE_FEED ) {
				mLineVector.add( lastCR );
				mLineLengthVector.add( i-lastCR );
				lastCR = i+1;
				if( (i+1) < count ) {
					c = mString.charAt(i+1);
					if( c == CARRIAGE_RETURN || c == LINE_FEED ) {
						i++;
						lastCR = i+1;
					}
				}
			}
		}
		if( i != lastCR ) {
			mLineVector.add( lastCR );
			mLineLengthVector.add( i-lastCR );
		}
	}
	public final int getSrcPosToLine( int pos ) {
		if( mLineVector == null ) {
			generateLineVector();
		}
		// 2分法によって位置を求める
		int s = 0;
		int e = mLineVector.size();
		while( true ) {
			if( (e-s) <= 1 ) return s + mLineOffset;
			int m = s + (e-s)/2;
			if( mLineVector.get(m) > pos )
				e = m;
			else
				s = m;
		}
	}
	public final int getLineToSrcPos( int pos ) {
		if( mLineVector == null ) {
			generateLineVector();
		}
		return mLineVector.get(pos);
	}
	public final String getLine( int line ) {
		if( mLineVector == null ) {
			generateLineVector();
		}
		int start = mLineVector.get(line);
		int length = mLineLengthVector.get(line);
		return mString.substring(start, start+length );
	}
	public final int getMaxLine() {
		if( mLineVector == null ) {
			generateLineVector();
		}
		return mLineVector.size();
	}
}
