package jp.kirikiri.tvp2.base;

import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.StorageInterface;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TextWriteStreamInterface;
import jp.kirikiri.tvp2.TVP;

public class StorageIO implements StorageInterface {

	@Override
	public String readText(String name, String modestr) throws TJSException {
		return Storage.readText(name, modestr);
	}

	@Override
	public TextWriteStreamInterface createTextWriteStream(String name, String modestr) throws TJSException {
		return new TextWriteStream(name,modestr);
	}

	@Override
	public BinaryStream createBinaryWriteStream( String name ) throws TJSException {
		String filepath = TVP.DataPath + "/" + name;
		return Storage.createStream( filepath, BinaryStream.WRITE );
	}
}
