/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.graphicImage;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.ResourceLoader;

@Name(value="org.jboss.seam.graphicImage.image")
@Install(precedence=0)
@BypassInterceptors
public class Image
implements Serializable {
    public static final int PNG_IMAGE_TYPE = 2;
    public static final int DEFAULT_IMAGE_TYPE = 1;
    private static final Type DEFAULT_CONTENT_TYPE = Type.IMAGE_PNG;
    private transient Object input;
    private byte[] output;
    private boolean dirty;
    private Type contentType = DEFAULT_CONTENT_TYPE;
    private transient BufferedImage bufferedImage;

    public Image setInput(Object value) throws IOException {
        this.input = value;
        this.readImage();
        return this;
    }

    public byte[] getImage() throws IOException {
        if ((this.dirty || this.output == null) && this.bufferedImage != null) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.bufferedImage, this.getContentType().getImageFormatName(), outputStream);
            this.output = outputStream.toByteArray();
        }
        return this.output;
    }

    public Type getContentType() {
        return this.contentType;
    }

    public void setContentType(Type contentType) {
        this.contentType = contentType;
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
        this.dirty = true;
    }

    public Double getRatio() throws IOException {
        if (this.bufferedImage == null) {
            return null;
        }
        Double ratio = (double)this.bufferedImage.getWidth() / (double)this.bufferedImage.getHeight();
        return ratio;
    }

    public Boolean isRatio(double ratio, double precision) throws IOException {
        if (this.bufferedImage == null) {
            return null;
        }
        double error = ratio * precision;
        return ratio - error < this.getRatio() && this.getRatio() <= ratio + error;
    }

    public Integer getWidth() throws IOException {
        if (this.bufferedImage == null) {
            return null;
        }
        return this.bufferedImage.getWidth();
    }

    public Integer getHeight() throws IOException {
        if (this.bufferedImage == null) {
            return null;
        }
        return this.bufferedImage.getHeight();
    }

    public Image adjustRatio(double desiredRatio, double precision) throws InterruptedException, IOException {
        if (this.bufferedImage == null) {
            return this;
        }
        if (!this.isRatio(desiredRatio, precision).booleanValue()) {
            if (this.getRatio() > desiredRatio) {
                double desiredHeight = this.getRatio() * (double)this.getHeight().intValue() / desiredRatio;
                double stripHeight = (desiredHeight - (double)this.getHeight().intValue()) / 2.0;
                BufferedImage newImage = new BufferedImage(this.getWidth(), (int)((double)this.getHeight().intValue() + stripHeight * 2.0), this.getImageType());
                Graphics2D graphics2D = this.createGraphics(newImage);
                graphics2D.drawImage((java.awt.Image)this.bufferedImage, 0, (int)stripHeight, null);
                this.bufferedImage = newImage;
            } else if (this.getRatio() < desiredRatio) {
                double desiredWidth = this.getRatio() * (double)this.getWidth().intValue() / desiredRatio;
                double stripWidth = (desiredWidth - (double)this.getWidth().intValue()) / 2.0;
                BufferedImage newImage = new BufferedImage((int)((double)this.getWidth().intValue() + stripWidth * 2.0), this.getHeight(), this.getImageType());
                Graphics2D graphics2D = this.createGraphics(newImage);
                graphics2D.drawImage((java.awt.Image)this.bufferedImage, (int)stripWidth, 0, null);
                this.bufferedImage = newImage;
            }
            this.dirty = true;
        }
        return this;
    }

    public Image blur(int radius) throws IOException {
        if (this.bufferedImage == null) {
            return this;
        }
        BufferedImage newImage = new BufferedImage(this.getWidth(), this.getHeight(), this.getImageType());
        int blurWidth = (radius - 1) * 2 + 1;
        int pixels = blurWidth * blurWidth;
        float weight = 1.0f / (float)pixels;
        float[] elements = new float[pixels];
        for (int i = 0; i < pixels; ++i) {
            elements[i] = weight;
        }
        Kernel kernel = new Kernel(blurWidth, blurWidth, elements);
        ConvolveOp simpleBlur = new ConvolveOp(kernel);
        simpleBlur.filter(this.bufferedImage, newImage);
        this.bufferedImage = newImage;
        this.dirty = true;
        return this;
    }

    public Image scaleToWidth(int width) throws IOException {
        if (this.bufferedImage == null) {
            return this;
        }
        int height = width * this.getHeight() / this.getWidth();
        BufferedImage newImage = new BufferedImage(width, height, this.getImageType());
        Graphics2D graphics2D = this.createGraphics(newImage);
        graphics2D.drawImage(this.bufferedImage, 0, 0, width, height, null);
        this.bufferedImage = newImage;
        this.dirty = true;
        return this;
    }

    public Image scaleToFit(int height, int width) throws IOException {
        float wratio;
        float hratio = height / this.getHeight();
        if (hratio < (wratio = (float)(width / this.getWidth()))) {
            return this.scaleToHeight(height);
        }
        return this.scaleToWidth(width);
    }

    public Image scaleToHeight(int height) throws IOException {
        if (this.bufferedImage == null) {
            return this;
        }
        int width = height * this.getWidth() / this.getHeight();
        BufferedImage newImage = new BufferedImage(width, height, this.getImageType());
        Graphics2D graphics2D = this.createGraphics(newImage);
        graphics2D.drawImage(this.bufferedImage, 0, 0, width, height, null);
        this.bufferedImage = newImage;
        this.dirty = true;
        return this;
    }

    public Image scale(double factor) throws IOException {
        if (this.bufferedImage == null) {
            return this;
        }
        int width = (int)((double)this.getWidth().intValue() * factor);
        int height = (int)((double)this.getHeight().intValue() * factor);
        BufferedImage newImage = new BufferedImage(width, height, this.getImageType());
        Graphics2D graphics2D = this.createGraphics(newImage);
        graphics2D.drawImage(this.bufferedImage, 0, 0, width, height, null);
        this.bufferedImage = newImage;
        this.dirty = true;
        return this;
    }

    public Image resize(int width, int height) {
        if (this.bufferedImage == null) {
            return this;
        }
        BufferedImage newImage = new BufferedImage(width, height, this.getImageType());
        Graphics2D graphics2D = this.createGraphics(newImage);
        graphics2D.drawImage(this.bufferedImage, 0, 0, width, height, null);
        this.bufferedImage = newImage;
        this.dirty = true;
        return this;
    }

    private void readImage() throws IOException {
        if (this.input instanceof URL) {
            this.readImage(((URL)this.input).openStream());
        } else if (this.input instanceof File) {
            this.readImage(((File)this.input).toURL().openStream());
        } else if (this.input instanceof String) {
            this.readImage(ResourceLoader.instance().getResourceAsStream((String)this.input));
        } else if (this.input instanceof InputStream) {
            this.readImage((InputStream)this.input);
        } else if (this.input != null && this.input.getClass().isArray() && this.input.getClass().getComponentType().isAssignableFrom(Byte.TYPE)) {
            byte[] b = (byte[])this.input;
            this.readImage(new ByteArrayInputStream(b));
        }
    }

    private Graphics2D createGraphics(BufferedImage image) {
        if (image == null) {
            return null;
        }
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.setBackground(new Color(255, 255, 255));
        if (Type.IMAGE_PNG.equals((Object)this.getContentType())) {
            graphics2D.setComposite(AlphaComposite.Src);
        }
        graphics2D.clearRect(0, 0, image.getWidth(), image.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        return graphics2D;
    }

    public static Image instance() {
        if (!Contexts.isConversationContextActive()) {
            throw new IllegalStateException("No active conversation scope");
        }
        return (Image)Component.getInstance(Image.class);
    }

    private void readImage(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Image pointed to must exist (input stream must not be null)");
        }
        ImageInputStream stream = ImageIO.createImageInputStream(inputStream);
        if (stream == null) {
            throw new IllegalArgumentException("Error creating image input stream from image");
        }
        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
        if (!iter.hasNext()) {
            return;
        }
        ImageReader reader = iter.next();
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(stream, true, true);
        String type = reader.getFormatName();
        this.setContentType(Type.getTypeByFormatName(type));
        this.bufferedImage = reader.read(0, param);
        stream.close();
        reader.dispose();
        this.dirty = true;
        inputStream.close();
    }

    private int getImageType() {
        if (Type.IMAGE_PNG.equals((Object)this.getContentType())) {
            return 2;
        }
        return 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        IMAGE_PNG("image/png", ".png", "PNG", new String[0]),
        IMAGE_JPEG("image/jpeg", ".jpg", "JPEG", "image/jpg"),
        IMAGE_GIF("image/gif", ".gif", "GIF", new String[0]);

        private String mimeType;
        private String extension;
        private String imageFormatName;
        private List<String> alternativeMimeTypes;

        private Type(String mimeType, String extension, String imageFormatName, String ... alternativeMimeTypes) {
            this.mimeType = mimeType;
            this.extension = extension;
            this.alternativeMimeTypes = Arrays.asList(alternativeMimeTypes);
            this.imageFormatName = imageFormatName;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getExtension() {
            return this.extension;
        }

        public List<String> getAlternativeMimeTypes() {
            return this.alternativeMimeTypes;
        }

        protected String getImageFormatName() {
            return this.imageFormatName;
        }

        public static Type getTypeByMimeType(String mimeType) {
            for (Type type : Type.values()) {
                if (!type.getMimeType().equals(mimeType) && !type.alternativeMimeTypes.contains(mimeType)) continue;
                return type;
            }
            return null;
        }

        public static Type getTypeByFormatName(String formatName) {
            for (Type type : Type.values()) {
                if (!type.getImageFormatName().equalsIgnoreCase(formatName)) continue;
                return type;
            }
            return null;
        }
    }
}

