/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.jboss.seam.Seam;
import org.jboss.seam.security.Identity;

public class IdentityRequestWrapper
extends HttpServletRequestWrapper {
    private Identity identity;

    public IdentityRequestWrapper(HttpServletRequest request) {
        super(request);
        this.identity = (Identity)request.getSession().getAttribute(Seam.getComponentName(Identity.class));
    }

    public String getRemoteUser() {
        return this.getUserPrincipal() != null ? this.getUserPrincipal().getName() : null;
    }

    public Principal getUserPrincipal() {
        return this.seamSecurityIsActive() ? this.identity.getPrincipal() : super.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.seamSecurityIsActive() ? this.identity.hasRole(role) : super.isUserInRole(role);
    }

    private boolean seamSecurityIsActive() {
        return Identity.isSecurityEnabled() && this.identity != null;
    }
}

