package kuzumeji.action.home.erp;
import java.util.ArrayList;
import java.util.List;
import kuzumeji.action.home.BaseEntityHome;
import kuzumeji.action.home.idm.UserHome;
import kuzumeji.entity.erp.Team;
import kuzumeji.entity.erp.Worker;
import kuzumeji.entity.erp.mng.ActualExpense;
import kuzumeji.entity.erp.mng.ActualPeriod;
import kuzumeji.entity.erp.mng.PlanWork;
import kuzumeji.entity.idm.User;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
/**
 * WorkerHome
 * @author nilcy
 */
@Name("workerHome")
public class WorkerHome extends BaseEntityHome<Worker> {
    /** S/N */
    private static final long serialVersionUID = -4614012822251312015L;
    /** TeamHome */
    @In(create = true)
    TeamHome teamHome;
    /** UserHome */
    @In(create = true)
    UserHome userHome;
    /**
     * get WorkerId
     * @return WorkerId
     */
    public Long getWorkerId() {
        return (Long) getId();
    }
    /**
     * set WorkerId
     * @param aWorkerId WorkerId
     */
    public void setWorkerId(Long aWorkerId) {
        setId(aWorkerId);
    }
    @Override
    protected Worker createInstance() {
        Worker person = new Worker();
        return person;
    }
    /**
     * load
     */
    public void load() {
        if (isIdDefined()) {
            wire();
        }
    }
    /**
     * wire
     */
    public void wire() {
        getInstance();
        Team team = this.teamHome.getDefinedInstance();
        if (team != null) {
            getInstance().setTeam(team);
        }
        User user = this.userHome.getDefinedInstance();
        if (user != null) {
            getInstance().setUser(user);
        }
    }
    /**
     * isWired
     * @return isWired
     */
    public boolean isWired() {
        return true;
    }
    /**
     * get DefinedInstance
     * @return DefinedInstance
     */
    public Worker getDefinedInstance() {
        return isIdDefined() ? getInstance() : null;
    }
    /**
     * get ActualExpenses
     * @return ActualExpenses
     */
    public List<ActualExpense> getActualExpenses() {
        return getInstance() == null ? null : new ArrayList<ActualExpense>(getInstance().getPartnerActualExpenses());
    }
    /**
     * get ActualPeriods
     * @return ActualPeriods
     */
    public List<ActualPeriod> getActualPeriods() {
        return getInstance() == null ? null : new ArrayList<ActualPeriod>(getInstance().getActualPeriods());
    }
    /**
     * get PlanWorks
     * @return PlanWorks
     */
    public List<PlanWork> getPlanWorks() {
        return getInstance() == null ? null : new ArrayList<PlanWork>(getInstance().getPlanWorks());
    }
}
