package kuzumeji.action.home.erp.mng;
import kuzumeji.action.home.BaseEntityHome;
import kuzumeji.action.home.erp.TeamHome;
import kuzumeji.action.home.erp.WorkerHome;
import kuzumeji.entity.Person;
import kuzumeji.entity.erp.mng.ActualExpense;
import kuzumeji.entity.erp.mng.ActualPeriod;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
@Name("actualExpenseHome")
public class ActualExpenseHome extends BaseEntityHome<ActualExpense> {
    @In(create = true)
    ActualPeriodHome actualPeriodHome;
    @In(create = true)
    TeamHome teamHome;
    @In(create = true)
    WorkerHome workerHome;
    public void setActualExpenseId(Long id) {
        setId(id);
    }
    public Long getActualExpenseId() {
        return (Long) getId();
    }
    @Override
    protected ActualExpense createInstance() {
        ActualExpense actualExpense = new ActualExpense();
        return actualExpense;
    }
    public void load() {
        if (isIdDefined()) {
            wire();
        }
    }
    public void wire() {
        getInstance();
        ActualPeriod actualPeriod = actualPeriodHome.getDefinedInstance();
        if (actualPeriod != null) {
            getInstance().setActualPeriod(actualPeriod);
        }
        Person person = workerHome.getDefinedInstance();
        if (person != null) {
            getInstance().setPartner(person);
        }
    }
    public boolean isWired() {
        if (getInstance().getActualPeriod() == null) return false;
        return true;
    }
    public ActualExpense getDefinedInstance() {
        return isIdDefined() ? getInstance() : null;
    }
}
