// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: HelperList.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.action.list.erp;
import kuzumeji.action.list.BaseEntityQuery;
import kuzumeji.entity.erp.Helper;
import org.jboss.seam.annotations.Name;
/**
 * Helper List
 * @author nilcy
 */
@Name("helperList")
public class HelperList extends BaseEntityQuery<Helper> {
    /** S/N */
    private static final long serialVersionUID = -5374751329485683532L;
    /** EJB-QL */
    private static final String EJBQL = "select helper from Helper helper";
    /** RESTRICTIONS */
    private static final String[] RESTRICTIONS = {
            "(helper.code) like (concat(#{helperList.helper.code},'%'))",
            "(helper.name) like (concat(#{helperList.helper.name},'%'))",
            "(helper.nick) like (concat(#{helperList.helper.nick},'%'))",
            "(helper.note) like (concat(#{helperList.helper.note},'%'))",
            "(helper.contact.zip)   like (concat(#{helperList.helper.contact.zip},'%'))", 
            "(helper.contact.addr1)  like (concat(#{helperList.helper.contact.addr1},'%'))",
            "(helper.contact.addr2) like (concat(#{helperList.helper.contact.addr2},'%'))",
            "(helper.contact.tel)   like (concat(#{helperList.helper.contact.tel},'%'))",
            "(helper.contact.mail)  like (concat(#{helperList.helper.contact.mail},'%'))",
            "(helper.contact.web)   like (concat(#{helperList.helper.contact.web},'%'))",};
    /** FILTER */
    private Helper helper = new Helper();
    /** CONSTRUCTOR */
    public HelperList() {
        super(EJBQL, RESTRICTIONS);
    }
    /**
     * @return FILTER
     */
    public Helper getHelper() {
        return this.helper;
    }
}
