// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: PartnerList.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.action.list.erp;
import kuzumeji.action.list.BaseEntityQuery;
import kuzumeji.entity.erp.Partner;
import org.jboss.seam.annotations.Name;
/**
 * Partner List
 * @author nilcy
 */
@Name("partnerList")
public class PartnerList extends BaseEntityQuery<Partner> {
    /** S/N */
    private static final long serialVersionUID = -3483625201013004360L;
    /** EJB-QL */
    private static final String EJBQL = "select partner from Partner partner";
    /** RESTRICTIONS */
    private static final String[] RESTRICTIONS = { "(partner.code) like (concat(#{partnerList.partner.code},'%'))",
            "(partner.name) like (concat(#{partnerList.partner.name},'%'))",
            "(partner.nick) like (concat(#{partnerList.partner.nick},'%'))",
            "(partner.note) like (concat(#{partnerList.partner.note},'%'))",
            "(partner.contact.zip)   like (concat(#{partnerList.partner.contact.zip},'%'))", 
            "(partner.contact.addr1)  like (concat(#{partnerList.partner.contact.addr1},'%'))",
            "(partner.contact.addr2) like (concat(#{partnerList.partner.contact.addr2},'%'))",
            "(partner.contact.tel)   like (concat(#{partnerList.partner.contact.tel},'%'))",
            "(partner.contact.mail)  like (concat(#{partnerList.partner.contact.mail},'%'))",
            "(partner.contact.web)   like (concat(#{partnerList.partner.contact.web},'%'))",};
    /** FILTER */
    private Partner partner = new Partner();
    /** CONSTRUCTOR */
    public PartnerList() {
        super(EJBQL, RESTRICTIONS);
    }
    /**
     * @return FILTER
     */
    public Partner getPartner() {
        return this.partner;
    }
}
