// ============================================================
// Copyright (C) 2009 Kuzumeji Wizard. All rights reserved.
// ____ GNU GENERAL PUBLIC LICENSE Version 3, 29 June 2007 ____
// ___________ http://www.gnu.org/licenses/gpl.html ___________
// File: $Id: SupplierList.java 1669 2009-11-08 11:43:31Z kuzumeji $
// ============================================================
package kuzumeji.action.list.erp;
import kuzumeji.action.list.BaseEntityQuery;
import kuzumeji.entity.erp.Supplier;
import org.jboss.seam.annotations.Name;
/**
 * Supplier List
 * @author nilcy
 */
@Name("supplierList")
public class SupplierList extends BaseEntityQuery<Supplier> {
    /** S/N */
    private static final long serialVersionUID = 5600776125684416944L;
    /** EJB-QL */
    private static final String EJBQL = "select supplier from Supplier supplier";
    /** RESTRICTIONS */
    private static final String[] RESTRICTIONS = { "(supplier.code) like (concat(#{supplierList.supplier.code},'%'))",
            "(supplier.name) like (concat(#{supplierList.supplier.name},'%'))",
            "(supplier.nick) like (concat(#{supplierList.supplier.nick},'%'))",
            "(supplier.note) like (concat(#{supplierList.supplier.note},'%'))",
            "(supplier.contact.zip)   like (concat(#{supplierList.supplier.contact.zip},'%'))", 
            "(supplier.contact.addr1)  like (concat(#{supplierList.supplier.contact.addr1},'%'))",
            "(supplier.contact.addr2) like (concat(#{supplierList.supplier.contact.addr2},'%'))",
            "(supplier.contact.tel)   like (concat(#{supplierList.supplier.contact.tel},'%'))",
            "(supplier.contact.mail)  like (concat(#{supplierList.supplier.contact.mail},'%'))",
            "(supplier.contact.web)   like (concat(#{supplierList.supplier.contact.web},'%'))",};
    /** FILTER */
    private Supplier supplier = new Supplier();
    /** CONSTRUCTOR */
    public SupplierList() {
        super(EJBQL, RESTRICTIONS);
    }
    /**
     * @return FILTER
     */
    public Supplier getSupplier() {
        return this.supplier;
    }
}
